/*
 * Decompiled with CFR 0.152.
 */
package no.ks.svarut.klient;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.io.Closeable;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import no.ks.svarut.klient.AuthenticationStrategy;
import no.ks.svarut.klient.ErrorMessage;
import no.ks.svarut.klient.SvarUtKlientException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.transport.HttpClientTransportDynamic;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\r\u0010\u0015\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0016J\u0016\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019*\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lno/ks/svarut/klient/BaseKlient;", "Ljava/io/Closeable;", "baseUrl", "", "authenticationStrategy", "Lno/ks/svarut/klient/AuthenticationStrategy;", "requestInterceptor", "Ljava/util/function/Function;", "Lorg/eclipse/jetty/client/Request;", "(Ljava/lang/String;Lno/ks/svarut/klient/AuthenticationStrategy;Ljava/util/function/Function;)V", "client", "Lorg/eclipse/jetty/client/HttpClient;", "getClient$fiks_svarut_klient", "()Lorg/eclipse/jetty/client/HttpClient;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "getObjectMapper$fiks_svarut_klient", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "close", "", "newRequest", "newRequest$fiks_svarut_klient", "bodyToException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "body", "fiks-svarut-klient"})
@SourceDebugExtension(value={"SMAP\nBaseKlient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseKlient.kt\nno/ks/svarut/klient/BaseKlient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,64:1\n1#2:65\n50#3:66\n43#3:67\n*S KotlinDebug\n*F\n+ 1 BaseKlient.kt\nno/ks/svarut/klient/BaseKlient\n*L\n59#1:66\n59#1:67\n*E\n"})
public abstract class BaseKlient
implements Closeable {
    @NotNull
    private final String baseUrl;
    @NotNull
    private final AuthenticationStrategy authenticationStrategy;
    @NotNull
    private final Function<Request, Request> requestInterceptor;
    @NotNull
    private final HttpClient client;
    private final ObjectMapper objectMapper;

    /*
     * WARNING - void declaration
     */
    public BaseKlient(@NotNull String baseUrl, @NotNull AuthenticationStrategy authenticationStrategy, @NotNull Function<Request, Request> requestInterceptor) {
        void $this$client_u24lambda_u240;
        ClientConnector clientConnector;
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)authenticationStrategy, (String)"authenticationStrategy");
        Intrinsics.checkNotNullParameter(requestInterceptor, (String)"requestInterceptor");
        this.baseUrl = baseUrl;
        this.authenticationStrategy = authenticationStrategy;
        this.requestInterceptor = requestInterceptor;
        ClientConnector clientConnector2 = clientConnector = new ClientConnector();
        BaseKlient baseKlient = this;
        boolean bl = false;
        $this$client_u24lambda_u240.setSslContextFactory(new SslContextFactory.Client());
        ClientConnectionFactory.Info[] infoArray = new ClientConnectionFactory.Info[]{};
        ClientConnector clientConnector3 = clientConnector;
        HttpClientTransport httpClientTransport = (HttpClientTransport)new HttpClientTransportDynamic(clientConnector3, infoArray);
        baseKlient.client = new HttpClient(httpClientTransport);
        this.objectMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper()).registerModule((Module)new JavaTimeModule()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        try {
            this.client.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public final HttpClient getClient$fiks_svarut_klient() {
        return this.client;
    }

    public final ObjectMapper getObjectMapper$fiks_svarut_klient() {
        return this.objectMapper;
    }

    @NotNull
    public final Request newRequest$fiks_svarut_klient() {
        Request request = this.requestInterceptor.apply(this.client.newRequest(this.baseUrl).onRequestBegin(this.authenticationStrategy::setAuthenticationHeaders));
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"apply(...)");
        return request;
    }

    @Override
    public void close() {
        try {
            this.client.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Exception bodyToException(@NotNull ObjectMapper $this$bodyToException, @NotNull String body) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$bodyToException, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        try {
            void $this$readValue$iv;
            object = this.objectMapper;
            Intrinsics.checkNotNull((Object)object);
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            object = new SvarUtKlientException((ErrorMessage)$this$readValue$iv.readValue(body, (TypeReference)new TypeReference<ErrorMessage>(){}));
        }
        catch (Exception e) {
            object = new RuntimeException("Uventet feil. Response body: " + body);
        }
        return object;
    }
}

