/*
 * Decompiled with CFR 0.152.
 */
package no.ks.svarut.klient.forsendelse.send.v2;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import no.ks.fiks.svarut.forsendelse.send.model.v2.Dokument;
import no.ks.fiks.svarut.forsendelse.send.model.v2.Forsendelse;
import no.ks.fiks.svarut.forsendelse.send.model.v2.SendForsendelseResponse;
import no.ks.svarut.klient.AuthenticationStrategy;
import no.ks.svarut.klient.BaseKlient;
import no.ks.svarut.klient.forsendelse.send.v2.MissingDataException;
import org.eclipse.jetty.client.ContentResponse;
import org.eclipse.jetty.client.InputStreamRequestContent;
import org.eclipse.jetty.client.MultiPartRequestContent;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.StringRequestContent;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MultiPart;
import org.eclipse.jetty.io.Content;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J*\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000fJ\u001c\u0010\u0015\u001a\u00020\u0016*\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0010H\u0002J(\u0010\u0019\u001a\u00020\u0016*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0014\u0010\u001a\u001a\u00020\u0016*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u001b"}, d2={"Lno/ks/svarut/klient/forsendelse/send/v2/SendKlientV2;", "Lno/ks/svarut/klient/BaseKlient;", "baseUrl", "", "authenticationStrategy", "Lno/ks/svarut/klient/AuthenticationStrategy;", "requestInterceptor", "Ljava/util/function/Function;", "Lorg/eclipse/jetty/client/Request;", "(Ljava/lang/String;Lno/ks/svarut/klient/AuthenticationStrategy;Ljava/util/function/Function;)V", "buildMultipartBody", "Lorg/eclipse/jetty/client/MultiPartRequestContent;", "forsendelse", "Lno/ks/fiks/svarut/forsendelse/send/model/v2/Forsendelse;", "dokumentnavnTilData", "", "Ljava/io/InputStream;", "pathSend", "kontoId", "Ljava/util/UUID;", "send", "addDokument", "", "dokumentnavn", "data", "addDokumenter", "addForsendelse", "fiks-svarut-klient"})
@SourceDebugExtension(value={"SMAP\nSendKlientV2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SendKlientV2.kt\nno/ks/svarut/klient/forsendelse/send/v2/SendKlientV2\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n50#2:87\n43#2:88\n1855#3,2:89\n*S KotlinDebug\n*F\n+ 1 SendKlientV2.kt\nno/ks/svarut/klient/forsendelse/send/v2/SendKlientV2\n*L\n43#1:87\n43#1:88\n67#1:89,2\n*E\n"})
public final class SendKlientV2
extends BaseKlient {
    public SendKlientV2(@NotNull String baseUrl, @NotNull AuthenticationStrategy authenticationStrategy, @NotNull Function<Request, Request> requestInterceptor) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)authenticationStrategy, (String)"authenticationStrategy");
        Intrinsics.checkNotNullParameter(requestInterceptor, (String)"requestInterceptor");
        super(baseUrl, authenticationStrategy, requestInterceptor);
    }

    private final String pathSend(UUID kontoId) {
        return "/api/v2/kontoer/" + kontoId + "/forsendelser/";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final UUID send(@NotNull UUID kontoId, @NotNull Forsendelse forsendelse, @NotNull Map<String, ? extends InputStream> dokumentnavnTilData) {
        void $this$readValue$iv;
        Intrinsics.checkNotNullParameter((Object)kontoId, (String)"kontoId");
        Intrinsics.checkNotNullParameter((Object)forsendelse, (String)"forsendelse");
        Intrinsics.checkNotNullParameter(dokumentnavnTilData, (String)"dokumentnavnTilData");
        ContentResponse response = this.newRequest$fiks_svarut_klient().method(HttpMethod.POST).path(this.pathSend(kontoId)).body((Request.Content)this.buildMultipartBody(forsendelse, dokumentnavnTilData)).idleTimeout(16L, TimeUnit.MINUTES).send();
        boolean bl = false;
        if (response.getStatus() != 200) {
            ObjectMapper objectMapper = this.getObjectMapper$fiks_svarut_klient();
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"<get-objectMapper>(...)");
            String string = response.getContentAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContentAsString(...)");
            throw this.bodyToException(objectMapper, string);
        }
        ObjectMapper objectMapper = this.getObjectMapper$fiks_svarut_klient();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"<get-objectMapper>(...)");
        ObjectMapper objectMapper2 = objectMapper;
        String string = response.getContentAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContentAsString(...)");
        String content$iv = string;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        UUID uUID = ((SendForsendelseResponse)$this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<SendForsendelseResponse>(){})).getId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"let(...)");
        return uUID;
    }

    private final MultiPartRequestContent buildMultipartBody(Forsendelse forsendelse, Map<String, ? extends InputStream> dokumentnavnTilData) {
        MultiPartRequestContent multiPartRequestContent;
        MultiPartRequestContent $this$buildMultipartBody_u24lambda_u241 = multiPartRequestContent = new MultiPartRequestContent();
        boolean bl = false;
        this.addForsendelse($this$buildMultipartBody_u24lambda_u241, forsendelse);
        this.addDokumenter($this$buildMultipartBody_u24lambda_u241, forsendelse, dokumentnavnTilData);
        $this$buildMultipartBody_u24lambda_u241.close();
        return multiPartRequestContent;
    }

    private final void addForsendelse(MultiPartRequestContent $this$addForsendelse, Forsendelse forsendelse) {
        $this$addForsendelse.addPart((MultiPart.Part)new MultiPart.ContentSourcePart("forsendelse", null, null, (Content.Source)new StringRequestContent(this.getObjectMapper$fiks_svarut_klient().writeValueAsString((Object)forsendelse))));
    }

    private final void addDokumenter(MultiPartRequestContent $this$addDokumenter, Forsendelse forsendelse, Map<String, ? extends InputStream> dokumentnavnTilData) {
        List<Dokument> list = forsendelse.getDokumenter();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDokumenter(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Dokument it = (Dokument)element$iv;
            boolean bl = false;
            String string = it.getFilnavn();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFilnavn(...)");
            InputStream inputStream = dokumentnavnTilData.get(it.getFilnavn());
            if (inputStream == null) {
                throw new MissingDataException("Fant ikke input stream for dokument " + it.getFilnavn());
            }
            this.addDokument($this$addDokumenter, string, inputStream);
        }
    }

    private final void addDokument(MultiPartRequestContent $this$addDokument, String dokumentnavn, InputStream data) {
        $this$addDokument.addPart((MultiPart.Part)new MultiPart.ContentSourcePart("filer", dokumentnavn, null, (Content.Source)new InputStreamRequestContent(data)));
    }
}

