/*
 * Decompiled with CFR 0.152.
 */
package no.ks.svarut.klient.forsendelse.slett.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.UUID;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import no.ks.svarut.klient.AuthenticationStrategy;
import no.ks.svarut.klient.BaseKlient;
import org.eclipse.jetty.client.ContentResponse;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.http.HttpMethod;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0012"}, d2={"Lno/ks/svarut/klient/forsendelse/slett/v2/SlettKlientV2;", "Lno/ks/svarut/klient/BaseKlient;", "baseUrl", "", "authenticationStrategy", "Lno/ks/svarut/klient/AuthenticationStrategy;", "requestInterceptor", "Ljava/util/function/Function;", "Lorg/eclipse/jetty/client/Request;", "(Ljava/lang/String;Lno/ks/svarut/klient/AuthenticationStrategy;Ljava/util/function/Function;)V", "pathSlettFiler", "forsendelseId", "Ljava/util/UUID;", "slettAlleFiler", "", "slettFiler", "slettetype", "slettOriginalDokumenter", "fiks-svarut-klient"})
public final class SlettKlientV2
extends BaseKlient {
    public SlettKlientV2(@NotNull String baseUrl, @NotNull AuthenticationStrategy authenticationStrategy, @NotNull Function<Request, Request> requestInterceptor) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)authenticationStrategy, (String)"authenticationStrategy");
        Intrinsics.checkNotNullParameter(requestInterceptor, (String)"requestInterceptor");
        super(baseUrl, authenticationStrategy, requestInterceptor);
    }

    private final String pathSlettFiler(UUID forsendelseId) {
        return "/api/v2/forsendelser/" + forsendelseId + "/dokumenter";
    }

    public final void slettOriginalDokumenter(@NotNull UUID forsendelseId) {
        Intrinsics.checkNotNullParameter((Object)forsendelseId, (String)"forsendelseId");
        this.slettFiler(forsendelseId, "ORIGINALDOKUMENTER");
    }

    public final void slettAlleFiler(@NotNull UUID forsendelseId) {
        Intrinsics.checkNotNullParameter((Object)forsendelseId, (String)"forsendelseId");
        this.slettFiler(forsendelseId, "ALLE");
    }

    private final void slettFiler(UUID forsendelseId, String slettetype) {
        ContentResponse response = this.newRequest$fiks_svarut_klient().method(HttpMethod.DELETE).path(this.pathSlettFiler(forsendelseId)).param("slettetype", slettetype).send();
        boolean bl = false;
        if (response.getStatus() != 204) {
            ObjectMapper objectMapper = this.getObjectMapper$fiks_svarut_klient();
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"<get-objectMapper>(...)");
            String string = response.getContentAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContentAsString(...)");
            throw this.bodyToException(objectMapper, string);
        }
    }
}

