/*
 * Decompiled with CFR 0.152.
 */
package no.ks.fiks.maskinporten;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.util.JSONObjectUtils;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringEntryLoader;
import net.jodah.expiringmap.ExpiringMap;
import net.jodah.expiringmap.ExpiringValue;
import no.ks.fiks.maskinporten.AccessTokenRequest;
import no.ks.fiks.maskinporten.JWSHeaderProvider;
import no.ks.fiks.maskinporten.Maskinportenklient;
import no.ks.fiks.maskinporten.MaskinportenklientBuilder;
import no.ks.fiks.maskinporten.MaskinportenklientKt;
import no.ks.fiks.maskinporten.MaskinportenklientOperations;
import no.ks.fiks.maskinporten.MaskinportenklientProperties;
import no.ks.fiks.maskinporten.VirksomhetssertifikatJWSHeaderProvider;
import no.ks.fiks.maskinporten.error.MaskinportenClientTokenRequestException;
import no.ks.fiks.maskinporten.error.MaskinportenTokenRequestException;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.MDC;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u0000 =2\u00020\u0001:\u0001=B+\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u001f\b\u0017\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000fB\u001d\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J \u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u001eH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u001a\u0010$\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00172\b\u0010%\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J!\u0010'\u001a\u00020\u00052\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050)\"\u00020\u0005H\u0017\u00a2\u0006\u0002\u0010*J\u0016\u0010'\u001a\u00020\u00052\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050+H\u0017J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0017H\u0016J)\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00052\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050)\"\u00020\u0005H\u0017\u00a2\u0006\u0002\u0010/J\u001e\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00052\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050+H\u0017J)\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u00052\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050)\"\u00020\u0005H\u0017\u00a2\u0006\u0002\u0010/J\u001e\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u00052\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050+H\u0017J\u001c\u00102\u001a\u0002032\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020605H\u0002J\u001c\u00107\u001a\u0002032\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020605H\u0002J\u0010\u00109\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\u001c\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u000206052\u0006\u0010;\u001a\u00020\u0005H\u0002J(\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u000206052\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020605H\u0002R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00050\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lno/ks/fiks/maskinporten/Maskinportenklient;", "Lno/ks/fiks/maskinporten/MaskinportenklientOperations;", "keyStore", "Ljava/security/KeyStore;", "privateKeyAlias", "", "privateKeyPassword", "", "properties", "Lno/ks/fiks/maskinporten/MaskinportenklientProperties;", "(Ljava/security/KeyStore;Ljava/lang/String;[CLno/ks/fiks/maskinporten/MaskinportenklientProperties;)V", "privateKey", "Ljava/security/PrivateKey;", "certificate", "Ljava/security/cert/X509Certificate;", "(Ljava/security/PrivateKey;Ljava/security/cert/X509Certificate;Lno/ks/fiks/maskinporten/MaskinportenklientProperties;)V", "jwsHeaderProvider", "Lno/ks/fiks/maskinporten/JWSHeaderProvider;", "(Ljava/security/PrivateKey;Lno/ks/fiks/maskinporten/JWSHeaderProvider;Lno/ks/fiks/maskinporten/MaskinportenklientProperties;)V", "jwsHeader", "Lcom/nimbusds/jose/JWSHeader;", "map", "Lnet/jodah/expiringmap/ExpiringMap;", "Lno/ks/fiks/maskinporten/AccessTokenRequest;", "signer", "Lcom/nimbusds/jose/JWSSigner;", "acquireAccessToken", "accessTokenRequest", "actuallyExecuteRequest", "httpRequestResponse", "Lkotlin/Function1;", "Lorg/apache/hc/client5/http/impl/classic/CloseableHttpClient;", "createHttpRequest", "Lorg/apache/hc/core5/http/ClassicHttpRequest;", "entityBuffer", "", "createJwtRequestForAccessToken", "jtiId", "doAcquireAccessToken", "getAccessToken", "scopes", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "request", "getAccessTokenWithAudience", "audience", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getDelegatedAccessToken", "consumerOrg", "getExp", "", "accessToken", "", "", "getExpiresIn", "json", "getTokenForRequest", "parse", "value", "parseAccessToken", "Companion", "maskinporten-client"})
@SourceDebugExtension(value={"SMAP\nMaskinportenklient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Maskinportenklient.kt\nno/ks/fiks/maskinporten/Maskinportenklient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KotlinLoggingMDC.kt\nmu/KotlinLoggingMDCKt\n*L\n1#1,320:1\n1#2:321\n1#2:329\n20#3,7:322\n28#3,7:330\n*S KotlinDebug\n*F\n+ 1 Maskinportenklient.kt\nno/ks/fiks/maskinporten/Maskinportenklient\n*L\n209#1:329\n209#1:322,7\n209#1:330,7\n*E\n"})
public final class Maskinportenklient
implements MaskinportenklientOperations {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MaskinportenklientProperties properties;
    @NotNull
    private final JWSHeader jwsHeader;
    @NotNull
    private final JWSSigner signer;
    @NotNull
    private final ExpiringMap<AccessTokenRequest, String> map;

    public Maskinportenklient(@NotNull PrivateKey privateKey, @NotNull JWSHeaderProvider jwsHeaderProvider, @NotNull MaskinportenklientProperties properties) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)jwsHeaderProvider, (String)"jwsHeaderProvider");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.properties = properties;
        this.jwsHeader = jwsHeaderProvider.buildJWSHeader();
        this.signer = (JWSSigner)new RSASSASigner(privateKey);
        ExpiringMap.Builder builder = ExpiringMap.builder().variableExpiration();
        ExpiringEntryLoader expiringEntryLoader = arg_0 -> Maskinportenklient._init_$lambda$0(this, arg_0);
        Intrinsics.checkNotNull((Object)expiringEntryLoader, (String)"null cannot be cast to non-null type net.jodah.expiringmap.ExpiringEntryLoader<no.ks.fiks.maskinporten.AccessTokenRequest, kotlin.String>");
        ExpiringMap expiringMap = builder.expiringEntryLoader(expiringEntryLoader).build();
        Intrinsics.checkNotNullExpressionValue((Object)expiringMap, (String)"builder()\n            .v\u2026ng>)\n            .build()");
        this.map = expiringMap;
    }

    @Deprecated(message="Use MaskinportenklientBuilder")
    public Maskinportenklient(@NotNull KeyStore keyStore, @Nullable String privateKeyAlias, @Nullable char[] privateKeyPassword, @NotNull MaskinportenklientProperties properties) {
        Intrinsics.checkNotNullParameter((Object)keyStore, (String)"keyStore");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Key key = keyStore.getKey(privateKeyAlias, privateKeyPassword);
        Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type java.security.PrivateKey");
        PrivateKey privateKey = (PrivateKey)key;
        Certificate certificate = keyStore.getCertificate(privateKeyAlias);
        Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
        this(privateKey, (X509Certificate)certificate, properties);
    }

    @Deprecated(message="Use MaskinportenklientBuilder")
    public Maskinportenklient(@NotNull PrivateKey privateKey, @NotNull X509Certificate certificate, @NotNull MaskinportenklientProperties properties) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this(privateKey, new VirksomhetssertifikatJWSHeaderProvider(certificate), properties);
    }

    private final long getExpiresIn(Map<String, ? extends Object> json) {
        Object value = Objects.requireNonNull(json.get("expires_in"), "JSON response fra Maskinporten mangler felt 'expires_in'");
        return Long.parseLong(String.valueOf(value));
    }

    private final long getExp(Map<String, ? extends Object> accessToken) {
        Object value = Objects.requireNonNull(accessToken.get("exp"), "Access token fra Maskinporten mangler felt 'exp'");
        return Long.parseLong(String.valueOf(value));
    }

    @Override
    @Deprecated(message="Bruk {@link #getAccessToken(AccessTokenRequest)}")
    @NotNull
    public String getAccessToken(@NotNull Collection<String> scopes) {
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        return this.getTokenForRequest(new AccessTokenRequest(CollectionsKt.toSet((Iterable)scopes), null, null, null, 14, null));
    }

    @Override
    @Deprecated(message="Bruk {@link #getAccessToken(AccessTokenRequest)}")
    @NotNull
    public String getAccessToken(String ... scopes) {
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        return this.getAccessToken(MaskinportenklientKt.access$scopesToCollection(Arrays.copyOf(scopes, scopes.length)));
    }

    @Override
    @Deprecated(message="Bruk {@link #getAccessToken(AccessTokenRequest)}")
    @NotNull
    public String getDelegatedAccessToken(@NotNull String consumerOrg, @NotNull Collection<String> scopes) {
        Intrinsics.checkNotNullParameter((Object)consumerOrg, (String)"consumerOrg");
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        return this.getTokenForRequest(new AccessTokenRequest(CollectionsKt.toSet((Iterable)scopes), consumerOrg, null, null, 12, null));
    }

    @Override
    @Deprecated(message="Bruk {@link #getAccessToken(AccessTokenRequest)}")
    @NotNull
    public String getDelegatedAccessToken(@NotNull String consumerOrg, String ... scopes) {
        Intrinsics.checkNotNullParameter((Object)consumerOrg, (String)"consumerOrg");
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        return this.getDelegatedAccessToken(consumerOrg, MaskinportenklientKt.access$scopesToCollection(Arrays.copyOf(scopes, scopes.length)));
    }

    @Override
    @Deprecated(message="Bruk {@link #getAccessToken(AccessTokenRequest)}")
    @NotNull
    public String getAccessTokenWithAudience(@NotNull String audience, @NotNull Collection<String> scopes) {
        Intrinsics.checkNotNullParameter((Object)audience, (String)"audience");
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        return this.getTokenForRequest(new AccessTokenRequest(CollectionsKt.toSet((Iterable)scopes), null, audience, null, 10, null));
    }

    @Override
    @Deprecated(message="Bruk {@link #getAccessToken(AccessTokenRequest)}\n     \n      ")
    @NotNull
    public String getAccessTokenWithAudience(@NotNull String audience, String ... scopes) {
        Intrinsics.checkNotNullParameter((Object)audience, (String)"audience");
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        return this.getAccessTokenWithAudience(audience, MaskinportenklientKt.access$scopesToCollection(Arrays.copyOf(scopes, scopes.length)));
    }

    @Override
    @NotNull
    public String getAccessToken(@NotNull AccessTokenRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.getTokenForRequest(request);
    }

    private final String getTokenForRequest(AccessTokenRequest accessTokenRequest) {
        if (!(!((Collection)accessTokenRequest.getScopes()).isEmpty())) {
            boolean bl = false;
            String string = "Minst ett scope m\u00e5 oppgies";
            throw new IllegalArgumentException(string.toString());
        }
        String string = (String)this.map.get((Object)accessTokenRequest);
        if (string == null) {
            throw new IllegalStateException("En ukjent feil skjedde ved fors\u00f8k p\u00e5 \u00e5 hente token fra Maskinporten");
        }
        return string;
    }

    private final String createJwtRequestForAccessToken(AccessTokenRequest accessTokenRequest, String jtiId) throws JOSEException {
        long issuedTimeInMillis = System.currentTimeMillis();
        long expirationTimeInMillis = issuedTimeInMillis + TimeUnit.MILLISECONDS.convert(2L, TimeUnit.MINUTES);
        String audience = this.properties.getAudience();
        String issuer = this.properties.getIssuer();
        String claimScopes = CollectionsKt.joinToString$default((Iterable)accessTokenRequest.getScopes(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        String string = accessTokenRequest.getConsumerOrg();
        if (string == null) {
            string = this.properties.getConsumerOrg();
        }
        String consumerOrg = string;
        MaskinportenklientKt.access$getLog$p().debug((Function0)new Function0<Object>(audience, issuer, claimScopes, consumerOrg, jtiId){
            final /* synthetic */ String $audience;
            final /* synthetic */ String $issuer;
            final /* synthetic */ String $claimScopes;
            final /* synthetic */ String $consumerOrg;
            final /* synthetic */ String $jtiId;
            {
                this.$audience = $audience;
                this.$issuer = $issuer;
                this.$claimScopes = $claimScopes;
                this.$consumerOrg = $consumerOrg;
                this.$jtiId = $jtiId;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Signing JWTRequest with audience='" + this.$audience + "',issuer='" + this.$issuer + "',scopes='" + this.$claimScopes + "',consumerOrg='" + this.$consumerOrg + "', jtiId='" + this.$jtiId + "'";
            }
        });
        JWTClaimsSet.Builder claimBuilder = new JWTClaimsSet.Builder().audience(audience).issuer(issuer).claim("scope", (Object)claimScopes).jwtID(jtiId).issueTime(new Date(issuedTimeInMillis)).expirationTime(new Date(expirationTimeInMillis));
        String string2 = consumerOrg;
        if (string2 != null) {
            String $this$createJwtRequestForAccessToken_u24lambda_u242 = string2;
            boolean bl = false;
            claimBuilder.claim("consumer_org", (Object)$this$createJwtRequestForAccessToken_u24lambda_u242);
        }
        String string3 = accessTokenRequest.getAudience();
        if (string3 != null) {
            String $this$createJwtRequestForAccessToken_u24lambda_u243 = string3;
            boolean bl = false;
            claimBuilder.claim("resource", (Object)$this$createJwtRequestForAccessToken_u24lambda_u243);
        }
        String string4 = accessTokenRequest.getPid();
        if (string4 != null) {
            String $this$createJwtRequestForAccessToken_u24lambda_u244 = string4;
            boolean bl = false;
            claimBuilder.claim("pid", (Object)$this$createJwtRequestForAccessToken_u24lambda_u244);
        }
        SignedJWT signedJWT = new SignedJWT(this.jwsHeader, claimBuilder.build());
        signedJWT.sign(this.signer);
        String string5 = signedJWT.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"signedJWT.serialize()");
        return string5;
    }

    private final String doAcquireAccessToken(AccessTokenRequest accessTokenRequest) {
        String string;
        try {
            string = this.acquireAccessToken(accessTokenRequest);
        }
        catch (JOSEException e) {
            MaskinportenklientKt.access$getLog$p().error((Throwable)e, (Function0)doAcquireAccessToken.1.INSTANCE);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            MaskinportenklientKt.access$getLog$p().error((Throwable)e, (Function0)doAcquireAccessToken.2.INSTANCE);
            throw new RuntimeException(e);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String acquireAccessToken(AccessTokenRequest accessTokenRequest) throws JOSEException, IOException {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String jtiId = string;
        Pair pair$iv = TuplesKt.to((Object)"jtiId", (Object)jtiId);
        boolean restorePrevious$iv = true;
        boolean $i$f$withLoggingContext = false;
        if (pair$iv.getSecond() == null) {
            boolean bl = false;
            String string2 = StringsKt.replace$default((String)StringsKt.replace$default((String)"grant_type={grant_type}&assertion={assertion}", (String)"{grant_type}", (String)"urn:ietf:params:oauth:grant-type:jwt-bearer", (boolean)false, (int)4, null), (String)"{assertion}", (String)this.createJwtRequestForAccessToken(accessTokenRequest, jtiId), (boolean)false, (int)4, null);
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] postData = byArray;
            String tokenEndpointUrlString = this.properties.getTokenEndpoint();
            MaskinportenklientKt.access$getLog$p().debug((Function0)new Function0<Object>(tokenEndpointUrlString){
                final /* synthetic */ String $tokenEndpointUrlString;
                {
                    this.$tokenEndpointUrlString = $tokenEndpointUrlString;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Acquiring access token from \"" + this.$tokenEndpointUrlString + "\"";
                }
            });
            long startTime = System.currentTimeMillis();
            return this.actuallyExecuteRequest((Function1<? super CloseableHttpClient, String>)((Function1)new Function1<CloseableHttpClient, String>(this, postData, tokenEndpointUrlString, startTime){
                final /* synthetic */ Maskinportenklient this$0;
                final /* synthetic */ byte[] $postData;
                final /* synthetic */ String $tokenEndpointUrlString;
                final /* synthetic */ long $startTime;
                {
                    this.this$0 = $receiver;
                    this.$postData = $postData;
                    this.$tokenEndpointUrlString = $tokenEndpointUrlString;
                    this.$startTime = $startTime;
                    super(1);
                }

                @Nullable
                public final String invoke(@NotNull CloseableHttpClient httpClient) {
                    Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
                    return (String)httpClient.execute(Maskinportenklient.access$createHttpRequest(this.this$0, this.$postData), (HttpClientResponseHandler)new HttpClientResponseHandler<String>(this.$tokenEndpointUrlString, this.$startTime){
                        final /* synthetic */ String $tokenEndpointUrlString;
                        final /* synthetic */ long $startTime;
                        {
                            this.$tokenEndpointUrlString = $tokenEndpointUrlString;
                            this.$startTime = $startTime;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Nullable
                        public String handleResponse(@NotNull ClassicHttpResponse classicHttpResponse) {
                            Object object;
                            Intrinsics.checkNotNullParameter((Object)classicHttpResponse, (String)"classicHttpResponse");
                            int responseCode = classicHttpResponse.getCode();
                            MaskinportenklientKt.access$getLog$p().debug((Function0)new Function0<Object>(this.$startTime, responseCode){
                                final /* synthetic */ long $startTime;
                                final /* synthetic */ int $responseCode;
                                {
                                    this.$startTime = $startTime;
                                    this.$responseCode = $responseCode;
                                    super(0);
                                }

                                @Nullable
                                public final Object invoke() {
                                    return "Access token response received in " + (System.currentTimeMillis() - this.$startTime) + " ms with status " + this.$responseCode;
                                }
                            });
                            if (200 == responseCode) {
                                InputStream inputStream = classicHttpResponse.getEntity().getContent();
                                if (inputStream != null) {
                                    Closeable closeable = inputStream;
                                    Throwable throwable = null;
                                    try {
                                        Object contentStream = (InputStream)closeable;
                                        boolean bl = false;
                                        Closeable closeable2 = contentStream;
                                        Object object2 = Charsets.UTF_8;
                                        Reader reader = new InputStreamReader((InputStream)closeable2, (Charset)object2);
                                        int n = 8192;
                                        closeable2 = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
                                        object2 = null;
                                        try {
                                            Object it = (BufferedReader)closeable2;
                                            boolean bl2 = false;
                                            it = TextStreamsKt.readText((Reader)((Reader)it));
                                        }
                                        catch (Throwable it) {
                                            object2 = it;
                                            throw it;
                                        }
                                        finally {
                                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object2);
                                        }
                                        contentStream = it;
                                        object = contentStream;
                                    }
                                    catch (Throwable contentStream) {
                                        throwable = contentStream;
                                        throw contentStream;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                    }
                                }
                                object = null;
                            } else {
                                String string;
                                Closeable closeable = classicHttpResponse.getEntity().getContent();
                                Throwable throwable = null;
                                try {
                                    String string2;
                                    InputStream errorContentStream = (InputStream)closeable;
                                    boolean bl = false;
                                    Intrinsics.checkNotNullExpressionValue((Object)errorContentStream, (String)"errorContentStream");
                                    Closeable closeable3 = errorContentStream;
                                    Object object3 = Charsets.UTF_8;
                                    Reader it = new InputStreamReader((InputStream)closeable3, (Charset)object3);
                                    int bl2 = 8192;
                                    closeable3 = it instanceof BufferedReader ? (BufferedReader)it : new BufferedReader(it, bl2);
                                    object3 = null;
                                    try {
                                        it = (BufferedReader)closeable3;
                                        boolean bl3 = false;
                                        string2 = TextStreamsKt.readText((Reader)it);
                                    }
                                    catch (Throwable throwable2) {
                                        object3 = throwable2;
                                        throw throwable2;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)object3);
                                    }
                                    string = string2;
                                }
                                catch (Throwable throwable3) {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                }
                                String errorFromMaskinporten = string;
                                MaskinportenklientKt.access$getLog$p().warn((Function0)new Function0<Object>(errorFromMaskinporten){
                                    final /* synthetic */ String $errorFromMaskinporten;
                                    {
                                        this.$errorFromMaskinporten = $errorFromMaskinporten;
                                        super(0);
                                    }

                                    @Nullable
                                    public final Object invoke() {
                                        return "Failed to get token: " + this.$errorFromMaskinporten;
                                    }
                                });
                                String exceptionMessage = "Http response code: " + responseCode + ", url: '" + this.$tokenEndpointUrlString + "', message: '" + errorFromMaskinporten + "'";
                                if (responseCode >= 400 && responseCode < 500) {
                                    throw new MaskinportenClientTokenRequestException(exceptionMessage, responseCode, errorFromMaskinporten);
                                }
                                throw new MaskinportenTokenRequestException(exceptionMessage, responseCode, errorFromMaskinporten);
                            }
                            return object;
                        }
                    });
                }
            }));
        }
        String previousValue$iv = MDC.get((String)((String)pair$iv.getFirst()));
        try {
            String string3;
            Closeable closeable = (Closeable)MDC.putCloseable((String)((String)pair$iv.getFirst()), (String)((String)pair$iv.getSecond()));
            Throwable throwable = null;
            try {
                MDC.MDCCloseable it$iv = (MDC.MDCCloseable)closeable;
                boolean bl = false;
                boolean bl2 = false;
                String tokenEndpointUrlString = StringsKt.replace$default((String)StringsKt.replace$default((String)"grant_type={grant_type}&assertion={assertion}", (String)"{grant_type}", (String)"urn:ietf:params:oauth:grant-type:jwt-bearer", (boolean)false, (int)4, null), (String)"{assertion}", (String)this.createJwtRequestForAccessToken(accessTokenRequest, jtiId), (boolean)false, (int)4, null);
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                byte[] byArray = tokenEndpointUrlString.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                byte[] postData = byArray;
                tokenEndpointUrlString = this.properties.getTokenEndpoint();
                MaskinportenklientKt.access$getLog$p().debug((Function0)new /* invalid duplicate definition of identical inner class */);
                long startTime = System.currentTimeMillis();
                string3 = this.actuallyExecuteRequest((Function1<? super CloseableHttpClient, String>)((Function1)new /* invalid duplicate definition of identical inner class */));
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    CloseableKt.closeFinally((Closeable)closeable, throwable);
                    throw throwable3;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            String string4 = string3;
            return string4;
        }
        finally {
            if (previousValue$iv != null) {
                MDC.put((String)((String)pair$iv.getFirst()), (String)previousValue$iv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String actuallyExecuteRequest(Function1<? super CloseableHttpClient, String> httpRequestResponse) {
        Object object;
        block7: {
            block8: {
                object = this.properties.getProvidedHttpClient();
                if (object == null) break block8;
                CloseableHttpClient httpClient = object;
                boolean bl = false;
                MaskinportenklientKt.access$getLog$p().debug((Function0)actuallyExecuteRequest.1.1.INSTANCE);
                String string = (String)httpRequestResponse.invoke((Object)httpClient);
                object = string;
                if (string != null) break block7;
            }
            Closeable closeable = (Closeable)HttpClientBuilder.create().disableAutomaticRetries().disableRedirectHandling().disableAuthCaching().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout((long)this.properties.getTimeoutMillis(), TimeUnit.MILLISECONDS).build()).build();
            Throwable throwable = null;
            try {
                CloseableHttpClient it = (CloseableHttpClient)closeable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                String string = (String)httpRequestResponse.invoke((Object)it);
                object = string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return object;
    }

    private final ClassicHttpRequest createHttpRequest(byte[] entityBuffer) {
        ClassicHttpRequest classicHttpRequest = ClassicRequestBuilder.post((String)this.properties.getTokenEndpoint()).setCharset(StandardCharsets.UTF_8).addHeader("Charset", StandardCharsets.UTF_8.name()).addHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.getMimeType()).setEntity(entityBuffer, ContentType.APPLICATION_FORM_URLENCODED).build();
        Intrinsics.checkNotNullExpressionValue((Object)classicHttpRequest, (String)"post(properties.tokenEnd\u2026DED)\n            .build()");
        return classicHttpRequest;
    }

    private final Map<String, Object> parse(String value) {
        Map map;
        try {
            Map map2 = JSONObjectUtils.parse((String)value);
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"{\n            JSONObject\u2026ls.parse(value)\n        }");
            map = map2;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    private final Map<String, Object> parseAccessToken(Map<String, ? extends Object> json) {
        Map map;
        try {
            Object accessToken = Objects.requireNonNull(json.get("access_token"), "JSON response fra Maskinporten mangler felt 'access_token'");
            Map map2 = JWSObject.parse((String)String.valueOf(accessToken)).getPayload().toJSONObject();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"{\n            val access\u2026.toJSONObject()\n        }");
            map = map2;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    private static final ExpiringValue _init_$lambda$0(Maskinportenklient this$0, AccessTokenRequest tokenRequest) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        String string = this$0.doAcquireAccessToken(tokenRequest);
        if (string == null) {
            throw new IllegalArgumentException("Got empty response from provider for request " + tokenRequest);
        }
        Map<String, Object> json = this$0.parse(string);
        Map<String, Object> accessToken = this$0.parseAccessToken(json);
        long expiresIn = this$0.getExpiresIn(json);
        long duration = expiresIn - (long)this$0.properties.getNumberOfSecondsLeftBeforeExpire();
        long exp = TimeUnit.MILLISECONDS.convert(this$0.getExp(accessToken), TimeUnit.SECONDS);
        MaskinportenklientKt.access$getLog$p().info((Function0)new Function0<Object>(json, exp, expiresIn, duration){
            final /* synthetic */ Map<String, Object> $json;
            final /* synthetic */ long $exp;
            final /* synthetic */ long $expiresIn;
            final /* synthetic */ long $duration;
            {
                this.$json = $json;
                this.$exp = $exp;
                this.$expiresIn = $expiresIn;
                this.$duration = $duration;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Adding access token to cache; access_token.scopes: '" + this.$json.get("scope") + "', access_token.exp: " + new Date(this.$exp) + ", expires_in: " + this.$expiresIn + " seconds. Expires from cache in " + this.$duration + " seconds (" + new Date(System.currentTimeMillis() + (long)1000 * this.$duration) + ").";
            }
        });
        return new ExpiringValue((Object)String.valueOf(json.get("access_token")), ExpirationPolicy.CREATED, duration, TimeUnit.SECONDS);
    }

    @JvmStatic
    @NotNull
    public static final MaskinportenklientBuilder builder() {
        return Companion.builder();
    }

    public static final /* synthetic */ ClassicHttpRequest access$createHttpRequest(Maskinportenklient $this, byte[] entityBuffer) {
        return $this.createHttpRequest(entityBuffer);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lno/ks/fiks/maskinporten/Maskinportenklient$Companion;", "", "()V", "builder", "Lno/ks/fiks/maskinporten/MaskinportenklientBuilder;", "maskinporten-client"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MaskinportenklientBuilder builder() {
            return new MaskinportenklientBuilder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

