/*
 * Decompiled with CFR 0.152.
 */
package no.ks.fiks.maskinporten;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import no.ks.fiks.maskinporten.AsymmetricKeyJWSHeaderProvider;
import no.ks.fiks.maskinporten.JWSHeaderProvider;
import no.ks.fiks.maskinporten.Maskinportenklient;
import no.ks.fiks.maskinporten.MaskinportenklientBuilder;
import no.ks.fiks.maskinporten.MaskinportenklientKt;
import no.ks.fiks.maskinporten.MaskinportenklientProperties;
import no.ks.fiks.maskinporten.VirksomhetssertifikatJWSHeaderProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lno/ks/fiks/maskinporten/MaskinportenklientBuilder;", "", "()V", "jwsHeaderProvider", "Lno/ks/fiks/maskinporten/JWSHeaderProvider;", "privateKey", "Ljava/security/PrivateKey;", "properties", "Lno/ks/fiks/maskinporten/MaskinportenklientProperties;", "build", "Lno/ks/fiks/maskinporten/Maskinportenklient;", "usingAsymmetricKey", "keyId", "", "usingJwsHeaderProvider", "usingVirksomhetssertifikat", "certificate", "Ljava/security/cert/X509Certificate;", "withPrivateKey", "withProperties", "maskinporten-client"})
@SourceDebugExtension(value={"SMAP\nMaskinportenklient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Maskinportenklient.kt\nno/ks/fiks/maskinporten/MaskinportenklientBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,320:1\n1#2:321\n*E\n"})
public final class MaskinportenklientBuilder {
    @Nullable
    private PrivateKey privateKey;
    @Nullable
    private JWSHeaderProvider jwsHeaderProvider;
    @Nullable
    private MaskinportenklientProperties properties;

    @NotNull
    public final MaskinportenklientBuilder withPrivateKey(@NotNull PrivateKey privateKey) {
        MaskinportenklientBuilder maskinportenklientBuilder;
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        MaskinportenklientBuilder it = maskinportenklientBuilder = this;
        boolean bl = false;
        this.privateKey = privateKey;
        return maskinportenklientBuilder;
    }

    @NotNull
    public final MaskinportenklientBuilder withProperties(@NotNull MaskinportenklientProperties properties) {
        MaskinportenklientBuilder maskinportenklientBuilder;
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        MaskinportenklientBuilder it = maskinportenklientBuilder = this;
        boolean bl = false;
        this.properties = properties;
        return maskinportenklientBuilder;
    }

    @NotNull
    public final MaskinportenklientBuilder usingVirksomhetssertifikat(@NotNull X509Certificate certificate) {
        MaskinportenklientBuilder maskinportenklientBuilder;
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        MaskinportenklientBuilder it = maskinportenklientBuilder = this;
        boolean bl = false;
        if (this.jwsHeaderProvider != null) {
            MaskinportenklientKt.access$getLog$p().warn((Function0)usingVirksomhetssertifikat.1.1.INSTANCE);
        }
        this.jwsHeaderProvider = new VirksomhetssertifikatJWSHeaderProvider(certificate);
        return maskinportenklientBuilder;
    }

    @NotNull
    public final MaskinportenklientBuilder usingAsymmetricKey(@NotNull String keyId) {
        MaskinportenklientBuilder maskinportenklientBuilder;
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        MaskinportenklientBuilder it = maskinportenklientBuilder = this;
        boolean bl = false;
        if (this.jwsHeaderProvider != null) {
            MaskinportenklientKt.access$getLog$p().warn((Function0)usingAsymmetricKey.1.1.INSTANCE);
        }
        this.jwsHeaderProvider = new AsymmetricKeyJWSHeaderProvider(keyId);
        return maskinportenklientBuilder;
    }

    @NotNull
    public final MaskinportenklientBuilder usingJwsHeaderProvider(@NotNull JWSHeaderProvider jwsHeaderProvider) {
        MaskinportenklientBuilder maskinportenklientBuilder;
        Intrinsics.checkNotNullParameter((Object)jwsHeaderProvider, (String)"jwsHeaderProvider");
        MaskinportenklientBuilder it = maskinportenklientBuilder = this;
        boolean bl = false;
        if (this.jwsHeaderProvider != null) {
            MaskinportenklientKt.access$getLog$p().warn((Function0)usingJwsHeaderProvider.1.1.INSTANCE);
        }
        this.jwsHeaderProvider = jwsHeaderProvider;
        return maskinportenklientBuilder;
    }

    @NotNull
    public final Maskinportenklient build() {
        PrivateKey privateKey = this.privateKey;
        if (privateKey == null) {
            throw new IllegalArgumentException("The \"privateKey\" property can not be null");
        }
        JWSHeaderProvider jWSHeaderProvider = this.jwsHeaderProvider;
        if (jWSHeaderProvider == null) {
            throw new IllegalArgumentException("Must configure client to use either virksomhetssertifikat, asymmetric key or custom JWSHeaderProvider");
        }
        MaskinportenklientProperties maskinportenklientProperties = this.properties;
        if (maskinportenklientProperties == null) {
            throw new IllegalArgumentException("The \"properties\" property can not be null");
        }
        return new Maskinportenklient(privateKey, jWSHeaderProvider, maskinportenklientProperties);
    }
}

