/*
 * Decompiled with CFR 0.152.
 */
package no.nav.arxaas.utils;

import java.util.List;
import no.nav.arxaas.model.Attribute;
import no.nav.arxaas.model.Request;
import no.nav.arxaas.utils.DataFactory;
import org.deidentifier.arx.AttributeType;
import org.deidentifier.arx.Data;
import org.springframework.stereotype.Component;

@Component
public class ARXDataFactory
implements DataFactory {
    public Data create(Request payload) {
        this.validateParameters(payload.getData(), payload.getAttributes());
        Data data = this.createData(payload.getData());
        this.setHierarchies(data, payload.getAttributes());
        this.setAttributeTypes(data, payload.getAttributes());
        return data;
    }

    private void validateParameters(List<String[]> rawData, List<Attribute> attributes) {
        if (rawData == null) {
            throw new IllegalArgumentException("rawData parameter is null");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("attributes parameter is null");
        }
    }

    private Data createData(List<String[]> rawData) {
        return Data.create(rawData);
    }

    private void setAttributeTypes(Data data, List<Attribute> attributes) {
        for (Attribute attribute : attributes) {
            data.getDefinition().setAttributeType(attribute.getField(), attribute.getAttributeTypeModel().getAttributeType());
        }
    }

    private void setHierarchies(Data data, List<Attribute> attributeList) {
        for (Attribute attribute : attributeList) {
            List rawHierarchy = attribute.getHierarchy();
            if (rawHierarchy == null) continue;
            AttributeType.Hierarchy hierarchy = AttributeType.Hierarchy.create((List)rawHierarchy);
            data.getDefinition().setAttributeType(attribute.getField(), (AttributeType)hierarchy);
        }
    }
}

