/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.abac;

import no.nav.common.health.HealthCheck;
import no.nav.common.health.HealthCheckResult;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class AbacHealthCheck
implements HealthCheck {
    private final String abacUrl;
    private final OkHttpClient client;

    public AbacHealthCheck(String abacUrl) {
        this.abacUrl = abacUrl;
        this.client = new OkHttpClient();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HealthCheckResult checkHealth() {
        Request request = new Request.Builder().url(this.abacUrl).get().build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                HealthCheckResult healthCheckResult2 = HealthCheckResult.unhealthy((String)("Received unexpected response from abac ping" + response.code()));
                return healthCheckResult2;
            }
            HealthCheckResult healthCheckResult = HealthCheckResult.healthy();
            return healthCheckResult;
        }
        catch (Exception e) {
            return HealthCheckResult.unhealthy((Throwable)e);
        }
    }
}

