/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.abac;

import no.nav.common.abac.AbacClient;
import no.nav.common.abac.XacmlMapper;
import no.nav.common.abac.domain.request.XacmlRequest;
import no.nav.common.abac.domain.response.XacmlResponse;
import no.nav.common.abac.exception.AbacException;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbacHttpClient
implements AbacClient {
    private static final Logger LOG = LoggerFactory.getLogger(AbacHttpClient.class);
    private final String abacUrl;
    private final String srvUsername;
    private final String srvPassword;
    private final OkHttpClient client;

    public AbacHttpClient(String abacUrl, String srvUsername, String srvPassword) {
        this.abacUrl = abacUrl;
        this.srvUsername = srvUsername;
        this.srvPassword = srvPassword;
        this.client = new OkHttpClient();
    }

    @Override
    public XacmlResponse sendRequest(XacmlRequest xacmlRequest) {
        String xacmlRequestJson = XacmlMapper.mapRequestToEntity(xacmlRequest);
        String xacmlResponseJson = this.sendRawRequest(xacmlRequestJson);
        return XacmlMapper.mapRawResponse(xacmlResponseJson);
    }

    @Override
    public String sendRawRequest(String xacmlRequestJson) {
        String string;
        block9: {
            Request request = new Request.Builder().url(this.abacUrl).addHeader("Authorization", Credentials.basic((String)this.srvUsername, (String)this.srvPassword)).post(RequestBody.create((MediaType)MediaType.get((String)"application/xacml+json"), (String)xacmlRequestJson)).build();
            Response response = this.client.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    LOG.error("ABAC returned: " + response.code() + " " + response.message());
                    throw new AbacException("An error has occured calling ABAC: " + response.code());
                }
                string = response.body().string();
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new AbacException(e);
                }
            }
            response.close();
        }
        return string;
    }
}

