/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.abac;

import no.nav.common.abac.AbacCachedClient;
import no.nav.common.abac.AbacClient;
import no.nav.common.abac.AbacHttpClient;
import no.nav.common.abac.AbacUtils;
import no.nav.common.abac.AuditLogger;
import no.nav.common.abac.Pep;
import no.nav.common.abac.XacmlRequestBuilder;
import no.nav.common.abac.XacmlResponseParser;
import no.nav.common.abac.domain.AbacPersonId;
import no.nav.common.abac.domain.request.ActionId;
import no.nav.common.abac.domain.request.XacmlRequest;
import no.nav.common.abac.domain.response.Decision;
import no.nav.common.abac.domain.response.XacmlResponse;
import no.nav.common.abac.exception.PepException;

public class VeilarbPep
implements Pep {
    public static final String VEILARB_DOMAIN = "veilarb";
    private final AbacClient abacClient;
    private final String srvUsername;
    private final AuditLogger auditLogger;

    public VeilarbPep(String abacUrl, String srvUsername, String srvPassword) {
        this.srvUsername = srvUsername;
        this.auditLogger = new AuditLogger();
        this.abacClient = new AbacCachedClient(new AbacHttpClient(abacUrl, srvUsername, srvPassword));
    }

    public VeilarbPep(String srvUsername, AbacClient abacClient, AuditLogger auditLogger) {
        this.srvUsername = srvUsername;
        this.abacClient = abacClient;
        this.auditLogger = auditLogger;
    }

    @Override
    public void sjekkVeilederTilgangTilEnhet(String veilederIdent, String enhetId) {
        XacmlRequest xacmlRequest = XacmlRequestBuilder.buildRequest(XacmlRequestBuilder.lagEnvironment(this.srvUsername), XacmlRequestBuilder.lagAction(ActionId.READ), XacmlRequestBuilder.lagVeilederAccessSubject(veilederIdent), XacmlRequestBuilder.lagEnhetResource(enhetId, VEILARB_DOMAIN));
        if (!this.harTilgang(xacmlRequest)) {
            throw new PepException("Veileder har ikke tilgang til enhet");
        }
    }

    @Override
    public void sjekkVeilederTilgangTilBruker(String veilederIdent, ActionId actionId, AbacPersonId personId) {
        XacmlRequest xacmlRequest = XacmlRequestBuilder.buildRequest(XacmlRequestBuilder.lagEnvironment(this.srvUsername), XacmlRequestBuilder.lagAction(actionId), XacmlRequestBuilder.lagVeilederAccessSubject(veilederIdent), XacmlRequestBuilder.lagPersonResource(personId, VEILARB_DOMAIN));
        if (!this.harTilgang(xacmlRequest)) {
            throw new PepException("Veileder har ikke tilgang til bruker");
        }
    }

    @Override
    public void sjekkTilgangTilPerson(String innloggetBrukerIdToken, ActionId actionId, AbacPersonId personId) {
        String oidcTokenBody = AbacUtils.extractOidcTokenBody(innloggetBrukerIdToken);
        XacmlRequest xacmlRequest = XacmlRequestBuilder.buildRequest(XacmlRequestBuilder.lagEnvironmentMedOidcTokenBody(this.srvUsername, oidcTokenBody), XacmlRequestBuilder.lagAction(actionId), null, XacmlRequestBuilder.lagPersonResource(personId, VEILARB_DOMAIN));
        if (!this.harTilgang(xacmlRequest)) {
            throw new PepException("Innlogget bruker har ikke tilgang til person");
        }
    }

    @Override
    public void sjekkVeilederTilgangTilKode6(String veilederIdent) {
        XacmlRequest xacmlRequest = XacmlRequestBuilder.buildRequest(XacmlRequestBuilder.lagEnvironment(this.srvUsername), null, XacmlRequestBuilder.lagVeilederAccessSubject(veilederIdent), XacmlRequestBuilder.lagKode6Resource(VEILARB_DOMAIN));
        if (!this.harTilgang(xacmlRequest)) {
            throw new PepException("Veileder har ikke tilgang til kode 6");
        }
    }

    @Override
    public void sjekkVeilederTilgangTilKode7(String veilederIdent) {
        XacmlRequest xacmlRequest = XacmlRequestBuilder.buildRequest(XacmlRequestBuilder.lagEnvironment(this.srvUsername), null, XacmlRequestBuilder.lagVeilederAccessSubject(veilederIdent), XacmlRequestBuilder.lagKode7Resource(VEILARB_DOMAIN));
        if (!this.harTilgang(xacmlRequest)) {
            throw new PepException("Veileder har ikke tilgang til kode 7");
        }
    }

    @Override
    public void sjekkVeilederTilgangTilEgenAnsatt(String veilederIdent) {
        XacmlRequest xacmlRequest = XacmlRequestBuilder.buildRequest(XacmlRequestBuilder.lagEnvironment(this.srvUsername), null, XacmlRequestBuilder.lagVeilederAccessSubject(veilederIdent), XacmlRequestBuilder.lagEgenAnsattResource(VEILARB_DOMAIN));
        if (!this.harTilgang(xacmlRequest)) {
            throw new PepException("Veileder har ikke tilgang til egen ansatt");
        }
    }

    @Override
    public AbacClient getAbacClient() {
        return this.abacClient;
    }

    private boolean harTilgang(XacmlRequest xacmlRequest) {
        this.auditLogger.logRequestInfo(xacmlRequest.getRequest());
        XacmlResponse xacmlResponse = this.abacClient.sendRequest(xacmlRequest);
        Decision decision = XacmlResponseParser.getSingleDecision(xacmlResponse);
        this.auditLogger.logResponseInfo(decision.name(), xacmlResponse, xacmlRequest.getRequest());
        return XacmlResponseParser.harTilgang(xacmlResponse);
    }
}

