/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.abac;

import no.nav.common.abac.domain.AbacPersonId;
import no.nav.common.abac.domain.Attribute;
import no.nav.common.abac.domain.request.AccessSubject;
import no.nav.common.abac.domain.request.Action;
import no.nav.common.abac.domain.request.ActionId;
import no.nav.common.abac.domain.request.Environment;
import no.nav.common.abac.domain.request.Request;
import no.nav.common.abac.domain.request.Resource;
import no.nav.common.abac.domain.request.XacmlRequest;

public class XacmlRequestBuilder {
    public static XacmlRequest buildRequest(Environment environment, Action action, AccessSubject accessSubject, Resource resource) {
        return new XacmlRequest().withRequest(new Request().withEnvironment(environment).withAction(action).withAccessSubject(accessSubject).withResource(resource));
    }

    public static AccessSubject lagVeilederAccessSubject(String veilederIdent) {
        return XacmlRequestBuilder.lagAccessSubject(veilederIdent, "InternBruker");
    }

    public static AccessSubject lagAccessSubject(String subjectId, String subjectType) {
        AccessSubject accessSubject = new AccessSubject();
        accessSubject.getAttribute().add(new Attribute("urn:oasis:names:tc:xacml:1.0:subject:subject-id", subjectId));
        accessSubject.getAttribute().add(new Attribute("no.nav.abac.attributter.subject.felles.subjectType", subjectType));
        return accessSubject;
    }

    public static Action lagAction(ActionId actionId) {
        Action action = new Action();
        action.getAttribute().add(new Attribute("urn:oasis:names:tc:xacml:1.0:action:action-id", actionId.getId()));
        return action;
    }

    public static Environment lagEnvironment(String srvUsername) {
        Environment environment = new Environment();
        environment.getAttribute().add(new Attribute("no.nav.abac.attributter.environment.felles.pep_id", srvUsername));
        return environment;
    }

    public static Environment lagEnvironmentMedOidcTokenBody(String srvUsername, String oidcTokenBody) {
        Environment environment = XacmlRequestBuilder.lagEnvironment(srvUsername);
        environment.getAttribute().add(new Attribute("no.nav.abac.attributter.environment.felles.oidc_token_body", oidcTokenBody));
        return environment;
    }

    public static Resource lagEnhetResource(String enhetId, String domain) {
        Resource resource = new Resource();
        resource.getAttribute().add(new Attribute("no.nav.abac.attributter.resource.felles.resource_type", "no.nav.abac.attributter.resource.veilarb.enhet.eiendel"));
        resource.getAttribute().add(new Attribute("no.nav.abac.attributter.resource.felles.domene", domain));
        resource.getAttribute().add(new Attribute("no.nav.abac.attributter.resource.veilarb.kontor_laas", enhetId));
        return resource;
    }

    public static Resource lagPersonResource(AbacPersonId personId, String domain) {
        Resource resource = new Resource();
        resource.getAttribute().add(new Attribute("no.nav.abac.attributter.resource.felles.resource_type", "no.nav.abac.attributter.resource.felles.person"));
        resource.getAttribute().add(new Attribute("no.nav.abac.attributter.resource.felles.domene", domain));
        resource.getAttribute().add(XacmlRequestBuilder.personIdAttribute(personId));
        return resource;
    }

    public static Resource lagKode7Resource(String domain) {
        Resource resource = new Resource();
        resource.getAttribute().add(new Attribute("no.nav.abac.attributter.resource.felles.resource_type", "no.nav.abac.attributter.subject.felles.har_tilgang_kode_7"));
        resource.getAttribute().add(new Attribute("no.nav.abac.attributter.resource.felles.domene", domain));
        return resource;
    }

    public static Resource lagKode6Resource(String domain) {
        Resource resource = new Resource();
        resource.getAttribute().add(new Attribute("no.nav.abac.attributter.resource.felles.resource_type", "no.nav.abac.attributter.subject.felles.har_tilgang_kode_6"));
        resource.getAttribute().add(new Attribute("no.nav.abac.attributter.resource.felles.domene", domain));
        return resource;
    }

    public static Resource lagEgenAnsattResource(String domain) {
        Resource resource = new Resource();
        resource.getAttribute().add(new Attribute("no.nav.abac.attributter.resource.felles.resource_type", "no.nav.abac.attributter.subject.felles.har_tilgang_egen_ansatt"));
        resource.getAttribute().add(new Attribute("no.nav.abac.attributter.resource.felles.domene", domain));
        return resource;
    }

    public static Resource lagVeilArbResource(String domain) {
        Resource resource = new Resource();
        resource.getAttribute().add(new Attribute("no.nav.abac.attributter.resource.felles.resource_type", "no.nav.abac.attributter.resource.veilarb"));
        resource.getAttribute().add(new Attribute("no.nav.abac.attributter.resource.felles.domene", domain));
        return resource;
    }

    public static Resource lagVeilArbPersonResource(AbacPersonId personId, String domain) {
        Resource resource = new Resource();
        resource.getAttribute().add(new Attribute("no.nav.abac.attributter.resource.felles.resource_type", "no.nav.abac.attributter.resource.veilarb.person"));
        resource.getAttribute().add(new Attribute("no.nav.abac.attributter.resource.felles.domene", domain));
        resource.getAttribute().add(XacmlRequestBuilder.personIdAttribute(personId));
        return resource;
    }

    public static Resource lagVeilArbUnderOppfolgingResource(AbacPersonId personId, String domain) {
        Resource resource = new Resource();
        resource.getAttribute().add(new Attribute("no.nav.abac.attributter.resource.felles.resource_type", "no.nav.abac.attributter.resource.veilarb.under_oppfoelging"));
        resource.getAttribute().add(new Attribute("no.nav.abac.attributter.resource.felles.domene", domain));
        resource.getAttribute().add(XacmlRequestBuilder.personIdAttribute(personId));
        return resource;
    }

    public static Attribute personIdAttribute(AbacPersonId personId) {
        switch (personId.getType()) {
            case FNR: {
                return new Attribute("no.nav.abac.attributter.resource.felles.person.fnr", personId.getId());
            }
            case AKTOR_ID: {
                return new Attribute("no.nav.abac.attributter.resource.felles.person.aktoerId_resource", personId.getId());
            }
        }
        throw new IllegalStateException("Ukjent verdi for person id type: " + personId.getType());
    }
}

