/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.abac.domain.request;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import no.nav.common.abac.domain.request.AccessSubject;
import no.nav.common.abac.domain.request.Action;
import no.nav.common.abac.domain.request.Environment;
import no.nav.common.abac.domain.request.Resource;

public class Request {
    private AccessSubject accessSubject;
    private Environment environment;
    private Action action;
    private List<Resource> resource;

    public Optional<Resource> getFirstResource() {
        if (this.resource == null || this.resource.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.resource.get(0));
    }

    public Request withEnvironment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public Request withAccessSubject(AccessSubject accessSubject) {
        this.accessSubject = accessSubject;
        return this;
    }

    public Request withAction(Action action) {
        this.action = action;
        return this;
    }

    public Request withResources(List<Resource> resource) {
        this.resource = resource;
        return this;
    }

    public Request withResource(Resource resource) {
        return this.withResources(Arrays.asList(resource));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Request)) {
            return false;
        }
        Request other = (Request)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AccessSubject this$accessSubject = this.getAccessSubject();
        AccessSubject other$accessSubject = other.getAccessSubject();
        if (this$accessSubject == null ? other$accessSubject != null : !((Object)this$accessSubject).equals(other$accessSubject)) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !((Object)this$environment).equals(other$environment)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)this$action).equals(other$action)) {
            return false;
        }
        List<Resource> this$resource = this.getResource();
        List<Resource> other$resource = other.getResource();
        return !(this$resource == null ? other$resource != null : !((Object)this$resource).equals(other$resource));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Request;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AccessSubject $accessSubject = this.getAccessSubject();
        result = result * 59 + ($accessSubject == null ? 43 : ((Object)$accessSubject).hashCode());
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : ((Object)$environment).hashCode());
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)$action).hashCode());
        List<Resource> $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : ((Object)$resource).hashCode());
        return result;
    }

    public AccessSubject getAccessSubject() {
        return this.accessSubject;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Action getAction() {
        return this.action;
    }

    public List<Resource> getResource() {
        return this.resource;
    }

    public String toString() {
        return "Request(accessSubject=" + this.getAccessSubject() + ", environment=" + this.getEnvironment() + ", action=" + this.getAction() + ", resource=" + this.getResource() + ")";
    }
}

