/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.abac;

import no.nav.common.abac.AbacClient;
import no.nav.common.abac.XacmlMapper;
import no.nav.common.abac.domain.request.XacmlRequest;
import no.nav.common.abac.domain.response.XacmlResponse;
import no.nav.common.abac.exception.AbacException;
import no.nav.common.health.HealthCheckResult;
import no.nav.common.health.HealthCheckUtils;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbacHttpClient
implements AbacClient {
    private static final Logger log = LoggerFactory.getLogger(AbacHttpClient.class);
    private final String abacUrl;
    private final String srvUsername;
    private final String srvPassword;
    private final OkHttpClient client;

    public AbacHttpClient(String abacUrl, String srvUsername, String srvPassword) {
        this.abacUrl = abacUrl;
        this.srvUsername = srvUsername;
        this.srvPassword = srvPassword;
        this.client = new OkHttpClient();
    }

    @Override
    public XacmlResponse sendRequest(XacmlRequest xacmlRequest) {
        String xacmlRequestJson = XacmlMapper.mapRequestToEntity(xacmlRequest);
        String xacmlResponseJson = this.sendRawRequest(xacmlRequestJson);
        return XacmlMapper.mapRawResponse(xacmlResponseJson);
    }

    @Override
    public String sendRawRequest(String xacmlRequestJson) {
        String string;
        block9: {
            Request request = new Request.Builder().url(this.abacUrl).addHeader("Authorization", Credentials.basic((String)this.srvUsername, (String)this.srvPassword)).post(RequestBody.create((MediaType)MediaType.get((String)"application/xacml+json"), (String)xacmlRequestJson)).build();
            Response response = this.client.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    log.error("ABAC returned unexpected status: " + response.code() + " " + response.message());
                    throw new AbacException("An error has occurred calling ABAC: " + response.code());
                }
                string = response.body().string();
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("Request to ABAC failed", (Throwable)e);
                    throw new AbacException(e);
                }
            }
            response.close();
        }
        return string;
    }

    public HealthCheckResult checkHealth() {
        Request request = new Request.Builder().url(this.abacUrl).addHeader("Authorization", Credentials.basic((String)this.srvUsername, (String)this.srvPassword)).build();
        return HealthCheckUtils.pingUrl((Request)request, (OkHttpClient)this.client);
    }
}

