/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.abac;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import no.nav.common.abac.domain.Attribute;
import no.nav.common.abac.domain.BaseAttribute;
import no.nav.common.abac.domain.request.Request;
import no.nav.common.abac.domain.request.XacmlRequest;

public class AbacUtils {
    public static String extractOidcTokenBody(String oidcToken) {
        String[] tokenParts = oidcToken.split("\\.");
        return tokenParts.length == 1 ? tokenParts[0] : tokenParts[1];
    }

    public static String getResourceAttribute(XacmlRequest request, String requestedAttribute) {
        return Optional.ofNullable(request).map(XacmlRequest::getRequest).flatMap(Request::getFirstResource).map(BaseAttribute::getAttribute).map(AbacUtils.findAttribute(requestedAttribute)).orElse("EMPTY");
    }

    private static Function<List<Attribute>, String> findAttribute(String requestedAttribute) {
        return attributes -> AbacUtils.findAttribute(attributes, requestedAttribute);
    }

    private static String findAttribute(List<Attribute> attributes, String requestedAttribute) {
        return attributes.stream().filter(a -> requestedAttribute.equals(a.getAttributeId())).findFirst().orElse(new Attribute("EMPTY", "EMPTY")).getValue();
    }
}

