/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.abac;

import java.util.Optional;
import java.util.function.Supplier;
import no.nav.common.abac.AbacClient;
import no.nav.common.abac.AbacUtils;
import no.nav.common.abac.Pep;
import no.nav.common.abac.XacmlRequestBuilder;
import no.nav.common.abac.XacmlResponseParser;
import no.nav.common.abac.audit.AuditConfig;
import no.nav.common.abac.audit.AuditLogFilter;
import no.nav.common.abac.audit.AuditLogger;
import no.nav.common.abac.audit.AuditRequestInfo;
import no.nav.common.abac.audit.AuditRequestInfoSupplier;
import no.nav.common.abac.audit.SubjectProvider;
import no.nav.common.abac.cef.CefAbacEventContext;
import no.nav.common.abac.cef.CefAbacResponseMapper;
import no.nav.common.abac.domain.request.ActionId;
import no.nav.common.abac.domain.request.Resource;
import no.nav.common.abac.domain.request.XacmlRequest;
import no.nav.common.abac.domain.response.XacmlResponse;
import no.nav.common.types.identer.EksternBrukerId;
import no.nav.common.types.identer.EnhetId;
import no.nav.common.types.identer.NavIdent;
import no.nav.common.utils.EnvironmentUtils;

public class VeilarbPep
implements Pep {
    private final AbacClient abacClient;
    private final String srvUsername;
    private final SubjectProvider subjectProvider;
    private final AuditConfig auditConfig;

    public VeilarbPep(String srvUsername, AbacClient abacClient, SubjectProvider subjectProvider, AuditConfig auditConfig) {
        this.srvUsername = srvUsername;
        this.abacClient = abacClient;
        this.subjectProvider = subjectProvider;
        this.auditConfig = auditConfig;
    }

    @Override
    public boolean harVeilederTilgangTilEnhet(NavIdent veilederIdent, EnhetId enhetId) {
        ActionId actionId = ActionId.READ;
        Resource resource = XacmlRequestBuilder.lagEnhetResource(enhetId, "veilarb");
        XacmlRequest xacmlRequest = XacmlRequestBuilder.buildRequest(XacmlRequestBuilder.lagEnvironment(this.srvUsername), XacmlRequestBuilder.lagAction(actionId), XacmlRequestBuilder.lagVeilederAccessSubject(veilederIdent), resource);
        Supplier<CefAbacEventContext> cefEventContext = () -> {
            CefAbacResponseMapper mapper = CefAbacResponseMapper.enhetIdMapper(enhetId, actionId, resource);
            return this.lagCefEventContext(mapper, veilederIdent.get());
        };
        return this.harTilgang(xacmlRequest, cefEventContext);
    }

    @Override
    public boolean harTilgangTilEnhet(String innloggetBrukerIdToken, EnhetId enhetId) {
        String oidcTokenBody = AbacUtils.extractOidcTokenBody(innloggetBrukerIdToken);
        Resource resource = XacmlRequestBuilder.lagEnhetResource(enhetId, "veilarb");
        ActionId actionId = ActionId.READ;
        XacmlRequest xacmlRequest = XacmlRequestBuilder.buildRequest(XacmlRequestBuilder.lagEnvironmentMedOidcTokenBody(this.srvUsername, oidcTokenBody), XacmlRequestBuilder.lagAction(actionId), null, resource);
        Supplier<CefAbacEventContext> cefEventContext = () -> {
            CefAbacResponseMapper mapper = CefAbacResponseMapper.enhetIdMapper(enhetId, actionId, resource);
            return this.lagCefEventContext(mapper, this.subjectProvider.getSubjectFromToken(innloggetBrukerIdToken));
        };
        return this.harTilgang(xacmlRequest, cefEventContext);
    }

    @Override
    public boolean harTilgangTilEnhetMedSperre(String innloggetBrukerIdToken, EnhetId enhetId) {
        String oidcTokenBody = AbacUtils.extractOidcTokenBody(innloggetBrukerIdToken);
        Resource resource = XacmlRequestBuilder.lagEnhetMedSperreResource(enhetId, "veilarb");
        ActionId actionId = ActionId.READ;
        XacmlRequest xacmlRequest = XacmlRequestBuilder.buildRequest(XacmlRequestBuilder.lagEnvironmentMedOidcTokenBody(this.srvUsername, oidcTokenBody), XacmlRequestBuilder.lagAction(actionId), null, resource);
        Supplier<CefAbacEventContext> cefEventContext = () -> {
            CefAbacResponseMapper mapper = CefAbacResponseMapper.enhetIdMapper(enhetId, actionId, resource);
            return this.lagCefEventContext(mapper, this.subjectProvider.getSubjectFromToken(innloggetBrukerIdToken));
        };
        return this.harTilgang(xacmlRequest, cefEventContext);
    }

    @Override
    public boolean harVeilederTilgangTilPerson(NavIdent veilederIdent, ActionId actionId, EksternBrukerId eksternBrukerId) {
        Resource resource = XacmlRequestBuilder.lagPersonResource(eksternBrukerId, "veilarb");
        XacmlRequest xacmlRequest = XacmlRequestBuilder.buildRequest(XacmlRequestBuilder.lagEnvironment(this.srvUsername), XacmlRequestBuilder.lagAction(actionId), XacmlRequestBuilder.lagVeilederAccessSubject(veilederIdent), resource);
        Supplier<CefAbacEventContext> cefEventContext = () -> {
            CefAbacResponseMapper mapper = CefAbacResponseMapper.personIdMapper(eksternBrukerId, actionId, resource);
            return this.lagCefEventContext(mapper, veilederIdent.get());
        };
        return this.harTilgang(xacmlRequest, cefEventContext);
    }

    @Override
    public boolean harTilgangTilPerson(String innloggetBrukerIdToken, ActionId actionId, EksternBrukerId eksternBrukerId) {
        String oidcTokenBody = AbacUtils.extractOidcTokenBody(innloggetBrukerIdToken);
        Resource resource = XacmlRequestBuilder.lagPersonResource(eksternBrukerId, "veilarb");
        XacmlRequest xacmlRequest = XacmlRequestBuilder.buildRequest(XacmlRequestBuilder.lagEnvironmentMedOidcTokenBody(this.srvUsername, oidcTokenBody), XacmlRequestBuilder.lagAction(actionId), null, resource);
        Supplier<CefAbacEventContext> cefEventContext = () -> {
            CefAbacResponseMapper mapper = CefAbacResponseMapper.personIdMapper(eksternBrukerId, actionId, resource);
            return this.lagCefEventContext(mapper, this.subjectProvider.getSubjectFromToken(innloggetBrukerIdToken));
        };
        return this.harTilgang(xacmlRequest, cefEventContext);
    }

    @Override
    public boolean harTilgangTilOppfolging(String innloggetBrukerIdToken) {
        String oidcTokenBody = AbacUtils.extractOidcTokenBody(innloggetBrukerIdToken);
        Resource resource = XacmlRequestBuilder.lagOppfolgingDomeneResource();
        String tokenSubject = this.subjectProvider.getSubjectFromToken(innloggetBrukerIdToken);
        XacmlRequest xacmlRequest = XacmlRequestBuilder.buildRequest(XacmlRequestBuilder.lagEnvironmentMedOidcTokenBody(this.srvUsername, oidcTokenBody), null, null, resource);
        Supplier<CefAbacEventContext> cefEventContext = () -> {
            CefAbacResponseMapper mapper = CefAbacResponseMapper.resourceMapper(resource);
            return this.lagCefEventContext(mapper, tokenSubject);
        };
        return this.harTilgang(xacmlRequest, cefEventContext);
    }

    @Override
    public boolean harVeilederTilgangTilModia(String innloggetVeilederIdToken) {
        String oidcTokenBody = AbacUtils.extractOidcTokenBody(innloggetVeilederIdToken);
        Resource resource = XacmlRequestBuilder.lagModiaDomeneResource();
        String veilederIdent = this.subjectProvider.getSubjectFromToken(innloggetVeilederIdToken);
        XacmlRequest xacmlRequest = XacmlRequestBuilder.buildRequest(XacmlRequestBuilder.lagEnvironmentMedOidcTokenBody(this.srvUsername, oidcTokenBody), null, null, resource);
        Supplier<CefAbacEventContext> cefEventContext = () -> {
            CefAbacResponseMapper mapper = CefAbacResponseMapper.resourceMapper(resource);
            return this.lagCefEventContext(mapper, veilederIdent);
        };
        return this.harTilgang(xacmlRequest, cefEventContext);
    }

    @Override
    public boolean harVeilederTilgangTilKode6(NavIdent veilederIdent) {
        Resource resource = XacmlRequestBuilder.lagKode6Resource("veilarb");
        XacmlRequest xacmlRequest = XacmlRequestBuilder.buildRequest(XacmlRequestBuilder.lagEnvironment(this.srvUsername), null, XacmlRequestBuilder.lagVeilederAccessSubject(veilederIdent), resource);
        Supplier<CefAbacEventContext> cefEventContext = () -> {
            CefAbacResponseMapper mapper = CefAbacResponseMapper.resourceMapper(resource);
            return this.lagCefEventContext(mapper, veilederIdent.get());
        };
        return this.harTilgang(xacmlRequest, cefEventContext);
    }

    @Override
    public boolean harVeilederTilgangTilKode7(NavIdent veilederIdent) {
        Resource resource = XacmlRequestBuilder.lagKode7Resource("veilarb");
        XacmlRequest xacmlRequest = XacmlRequestBuilder.buildRequest(XacmlRequestBuilder.lagEnvironment(this.srvUsername), null, XacmlRequestBuilder.lagVeilederAccessSubject(veilederIdent), resource);
        Supplier<CefAbacEventContext> cefEventContext = () -> {
            CefAbacResponseMapper mapper = CefAbacResponseMapper.resourceMapper(resource);
            return this.lagCefEventContext(mapper, veilederIdent.get());
        };
        return this.harTilgang(xacmlRequest, cefEventContext);
    }

    @Override
    public boolean harVeilederTilgangTilEgenAnsatt(NavIdent veilederIdent) {
        Resource resource = XacmlRequestBuilder.lagEgenAnsattResource("veilarb");
        XacmlRequest xacmlRequest = XacmlRequestBuilder.buildRequest(XacmlRequestBuilder.lagEnvironment(this.srvUsername), null, XacmlRequestBuilder.lagVeilederAccessSubject(veilederIdent), resource);
        Supplier<CefAbacEventContext> cefEventContext = () -> {
            CefAbacResponseMapper mapper = CefAbacResponseMapper.resourceMapper(resource);
            return this.lagCefEventContext(mapper, veilederIdent.get());
        };
        return this.harTilgang(xacmlRequest, cefEventContext);
    }

    @Override
    public AbacClient getAbacClient() {
        return this.abacClient;
    }

    private boolean harTilgang(XacmlRequest xacmlRequest, Supplier<CefAbacEventContext> cefEventContext) {
        XacmlResponse xacmlResponse = this.abacClient.sendRequest(xacmlRequest);
        if (cefEventContext != null && this.skalLogges(xacmlRequest, xacmlResponse)) {
            this.getAuditLogger().ifPresent(auditLogger -> auditLogger.logCef(xacmlRequest, xacmlResponse, (CefAbacEventContext)cefEventContext.get()));
        }
        return XacmlResponseParser.harTilgang(xacmlResponse);
    }

    private boolean skalLogges(XacmlRequest xacmlRequest, XacmlResponse xacmlResponse) {
        return this.getAuditRequestInfoSupplier().map(AuditRequestInfoSupplier::get).map(auditRequestInfo -> this.getAuditLogFilter().map(filter -> filter.isEnabled((AuditRequestInfo)auditRequestInfo, xacmlRequest, xacmlResponse)).orElse(true)).orElse(false);
    }

    private Optional<AuditLogger> getAuditLogger() {
        return this.auditConfig != null ? Optional.ofNullable(this.auditConfig.getAuditLogger()) : Optional.empty();
    }

    private Optional<AuditRequestInfoSupplier> getAuditRequestInfoSupplier() {
        return this.auditConfig != null ? Optional.ofNullable(this.auditConfig.getAuditRequestInfoSupplier()) : Optional.empty();
    }

    private Optional<AuditLogFilter> getAuditLogFilter() {
        return this.auditConfig != null ? Optional.ofNullable(this.auditConfig.getAuditLogFilter()) : Optional.empty();
    }

    private CefAbacEventContext lagCefEventContext(CefAbacResponseMapper mapper, String subjectId) {
        Optional<AuditRequestInfo> requestInfo = this.getAuditRequestInfoSupplier().map(AuditRequestInfoSupplier::get);
        return CefAbacEventContext.builder().applicationName(EnvironmentUtils.requireApplicationName()).callId(requestInfo.map(AuditRequestInfo::getCallId).orElse(null)).consumerId(requestInfo.map(AuditRequestInfo::getConsumerId).orElse(null)).requestMethod(requestInfo.map(AuditRequestInfo::getRequestMethod).orElse(null)).requestPath(requestInfo.map(AuditRequestInfo::getRequestPath).orElse(null)).subjectId(subjectId).mapper(mapper).build();
    }
}

