/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.abac.audit;

import java.util.List;
import java.util.function.Supplier;
import no.nav.common.abac.cef.CefAbacEvent;
import no.nav.common.abac.cef.CefAbacEventContext;
import no.nav.common.abac.cef.CefEvent;
import no.nav.common.abac.domain.request.XacmlRequest;
import no.nav.common.abac.domain.response.XacmlResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogger {
    private final Logger log;
    private final Supplier<Long> currentTimeInMillisSupplier;

    public AuditLogger() {
        this(LoggerFactory.getLogger((String)"AuditLogger"), System::currentTimeMillis);
    }

    public AuditLogger(Logger log, Supplier<Long> currentTimeInMillisSupplier) {
        this.log = log;
        this.currentTimeInMillisSupplier = currentTimeInMillisSupplier;
    }

    public void logCef(XacmlRequest xacmlRequest, XacmlResponse xacmlResponse, CefAbacEventContext context) {
        List<CefEvent> cefEvents = CefAbacEvent.createCefEvents(xacmlRequest, xacmlResponse, context, this.currentTimeInMillisSupplier);
        cefEvents.forEach(event -> this.log.info(event.toString()));
    }
}

