/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.abac.audit;

import javax.servlet.http.HttpServletRequest;
import no.nav.common.log.LogFilter;

public class AuditRequestInfo {
    private String callId;
    private String consumerId;
    private String requestMethod;
    private String requestPath;

    public static AuditRequestInfo fraHttpServletRequest(HttpServletRequest request) {
        return AuditRequestInfo.builder().callId(LogFilter.resolveCallId((HttpServletRequest)request)).consumerId(request.getHeader("Nav-Consumer-Id")).requestMethod(request.getMethod()).requestPath(request.getRequestURI()).build();
    }

    public String getCallId() {
        return this.callId;
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public static AuditRequestInfoBuilder builder() {
        return new AuditRequestInfoBuilder();
    }

    public AuditRequestInfo(String callId, String consumerId, String requestMethod, String requestPath) {
        this.callId = callId;
        this.consumerId = consumerId;
        this.requestMethod = requestMethod;
        this.requestPath = requestPath;
    }

    public static class AuditRequestInfoBuilder {
        private String callId;
        private String consumerId;
        private String requestMethod;
        private String requestPath;

        AuditRequestInfoBuilder() {
        }

        public AuditRequestInfoBuilder callId(String callId) {
            this.callId = callId;
            return this;
        }

        public AuditRequestInfoBuilder consumerId(String consumerId) {
            this.consumerId = consumerId;
            return this;
        }

        public AuditRequestInfoBuilder requestMethod(String requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public AuditRequestInfoBuilder requestPath(String requestPath) {
            this.requestPath = requestPath;
            return this;
        }

        public AuditRequestInfo build() {
            return new AuditRequestInfo(this.callId, this.consumerId, this.requestMethod, this.requestPath);
        }

        public String toString() {
            return "AuditRequestInfo.AuditRequestInfoBuilder(callId=" + this.callId + ", consumerId=" + this.consumerId + ", requestMethod=" + this.requestMethod + ", requestPath=" + this.requestPath + ")";
        }
    }
}

