/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.abac.audit;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.text.ParseException;
import no.nav.common.abac.audit.SubjectProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NimbusSubjectProvider
implements SubjectProvider {
    private static final Logger logger = LoggerFactory.getLogger(NimbusSubjectProvider.class);

    @Override
    public String getSubjectFromToken(String idToken) {
        try {
            JWT jwtToken = JWTParser.parse((String)idToken);
            return jwtToken.getJWTClaimsSet().getSubject();
        }
        catch (ParseException e) {
            logger.warn("Kunne ikke hente subject fra id token", (Throwable)e);
            return null;
        }
    }
}

