/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.abac.cef;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import no.nav.common.abac.cef.CefAbacEventContext;
import no.nav.common.abac.cef.CefAbacResponseMapper;
import no.nav.common.abac.cef.CefEvent;
import no.nav.common.abac.domain.request.XacmlRequest;
import no.nav.common.abac.domain.response.Advice;
import no.nav.common.abac.domain.response.AttributeAssignment;
import no.nav.common.abac.domain.response.Decision;
import no.nav.common.abac.domain.response.Response;
import no.nav.common.abac.domain.response.XacmlResponse;

public class CefAbacEvent {
    public static List<CefEvent> createCefEvents(XacmlRequest xacmlRequest, XacmlResponse xacmlResponse, CefAbacEventContext context, Supplier<Long> currentTimeInMillisSupplier) {
        return context.mapper.getMapper().apply(new CefAbacResponseMapper.Parameters(xacmlRequest, xacmlResponse)).stream().map(mapperResult -> {
            Response response = mapperResult.getResponse();
            CefEvent.Builder cefEventBuilder = CefEvent.builder();
            mapperResult.getCustomCefAttributes().forEach(cefEventBuilder::addAttribute);
            CefAbacEvent.addFromContext(cefEventBuilder, context, currentTimeInMillisSupplier);
            CefAbacEvent.addDecisionAttribute(response, cefEventBuilder);
            CefAbacEvent.addDenyAttributes(response, cefEventBuilder);
            return cefEventBuilder.build();
        }).collect(Collectors.toList());
    }

    private static void addFromContext(CefEvent.Builder cefEventBuilder, CefAbacEventContext context, Supplier<Long> currentTimeInMillisSupplier) {
        cefEventBuilder.cefVersion("0").applicationName(context.applicationName).logName("Sporingslogg").logFormatVersion("1.0").eventType("audit:access").description("ABAC Sporingslogg").addAttribute("end", currentTimeInMillisSupplier.get().toString()).addAttribute("suid", context.subjectId).addAttribute("sproc", context.callId).addAttribute("dproc", context.consumerId).addAttribute("requestMethod", context.requestMethod).addAttribute("request", context.requestPath);
    }

    private static void addDecisionAttribute(Response response, CefEvent.Builder cefEventBuilder) {
        cefEventBuilder.severity(Decision.Permit.equals((Object)response.getDecision()) ? CefEvent.Severity.INFO : CefEvent.Severity.WARN).addAttribute("flexString1", response.getDecision().name()).addAttribute("flexString1Label", "Decision");
    }

    private static void addDenyAttributes(Response response, CefEvent.Builder cefEventBuilder) {
        if (!Decision.Permit.equals((Object)response.getDecision())) {
            Advice advice = response.getAssociatedAdvice().get(0);
            CefAbacEvent.getAttributeFromAdvice("no.nav.abac.attributter.adviceorobligation.cause", advice).ifPresent(cause -> {
                cefEventBuilder.addAttribute("cs3", cause.getValue());
                cefEventBuilder.addAttribute("cs3Label", "deny_cause");
            });
            CefAbacEvent.getAttributeFromAdvice("no.nav.abac.attributter.adviceorobligation.deny_policy", advice).ifPresent(policy -> {
                cefEventBuilder.addAttribute("flexString2", policy.getValue());
                cefEventBuilder.addAttribute("flexString2Label", "deny_policy");
            });
            CefAbacEvent.getAttributeFromAdvice("no.nav.abac.attributter.adviceorobligation.deny_rule", advice).ifPresent(policy -> {
                cefEventBuilder.addAttribute("cs5", policy.getValue());
                cefEventBuilder.addAttribute("cs5Label", "deny_rule");
            });
        }
    }

    private static Optional<AttributeAssignment> getAttributeFromAdvice(String attribute, Advice advice) {
        return advice.getAttributeAssignment().stream().filter(attributeAssignment -> attribute.equals(attributeAssignment.getAttributeId())).findFirst();
    }
}

