/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.abac.cef;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import no.nav.common.abac.domain.Attribute;
import no.nav.common.abac.domain.request.ActionId;
import no.nav.common.abac.domain.request.Resource;
import no.nav.common.abac.domain.request.XacmlRequest;
import no.nav.common.abac.domain.response.Response;
import no.nav.common.abac.domain.response.XacmlResponse;
import no.nav.common.types.identer.EksternBrukerId;
import no.nav.common.types.identer.EnhetId;

public final class CefAbacResponseMapper {
    private final Function<Parameters, List<Result>> mapper;

    public CefAbacResponseMapper(Function<Parameters, List<Result>> mapper) {
        this.mapper = mapper;
    }

    public static CefAbacResponseMapper personIdMapper(EksternBrukerId eksternBrukerId, ActionId actionId, Resource resource) {
        Map<String, String> attributes = CefAbacResponseMapper.commonAttributes(actionId, resource);
        attributes.put("duid", eksternBrukerId.get());
        return CefAbacResponseMapper.attributesMapper(attributes);
    }

    public static CefAbacResponseMapper enhetIdMapper(EnhetId enhetId, ActionId actionId, Resource resource) {
        Map<String, String> attributes = CefAbacResponseMapper.commonAttributes(actionId, resource);
        attributes.put("cs2", enhetId.get());
        return CefAbacResponseMapper.attributesMapper(attributes);
    }

    public static CefAbacResponseMapper resourceMapper(Resource resource) {
        Map<String, String> attributes = CefAbacResponseMapper.commonAttributes(null, resource);
        return CefAbacResponseMapper.attributesMapper(attributes);
    }

    public static CefAbacResponseMapper attributesMapper(Map<String, String> attributes) {
        return new CefAbacResponseMapper(parameters -> parameters.getResponse().getResponse().stream().map(res -> new Result((Response)res, attributes)).collect(Collectors.toList()));
    }

    private static Map<String, String> commonAttributes(ActionId actionId, Resource resource) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Optional.ofNullable(actionId).map(action -> attributes.put("act", action.getId()));
        CefAbacResponseMapper.getAttribute("no.nav.abac.attributter.resource.felles.resource_type", resource).map(value -> attributes.put("requestContext", (String)value));
        CefAbacResponseMapper.getAttribute("no.nav.abac.attributter.resource.felles.domene", resource).map(value -> attributes.put("sourceServiceName", (String)value));
        return attributes;
    }

    private static Optional<String> getAttribute(String attribute, Resource resource) {
        return resource.getAttribute().stream().filter(x -> attribute.equals(x.getAttributeId())).findFirst().map(Attribute::getValue);
    }

    public Function<Parameters, List<Result>> getMapper() {
        return this.mapper;
    }

    public String toString() {
        return "CefAbacResponseMapper(mapper=" + this.getMapper() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CefAbacResponseMapper)) {
            return false;
        }
        CefAbacResponseMapper other = (CefAbacResponseMapper)o;
        Function<Parameters, List<Result>> this$mapper = this.getMapper();
        Function<Parameters, List<Result>> other$mapper = other.getMapper();
        return !(this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Function<Parameters, List<Result>> $mapper = this.getMapper();
        result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
        return result;
    }

    public static final class Result {
        private final Response response;
        private final Map<String, String> customCefAttributes;

        public Result(Response response, Map<String, String> customCefAttributes) {
            this.response = response;
            this.customCefAttributes = customCefAttributes;
        }

        public Response getResponse() {
            return this.response;
        }

        public Map<String, String> getCustomCefAttributes() {
            return this.customCefAttributes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            Response this$response = this.getResponse();
            Response other$response = other.getResponse();
            if (this$response == null ? other$response != null : !((Object)this$response).equals(other$response)) {
                return false;
            }
            Map<String, String> this$customCefAttributes = this.getCustomCefAttributes();
            Map<String, String> other$customCefAttributes = other.getCustomCefAttributes();
            return !(this$customCefAttributes == null ? other$customCefAttributes != null : !((Object)this$customCefAttributes).equals(other$customCefAttributes));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Response $response = this.getResponse();
            result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
            Map<String, String> $customCefAttributes = this.getCustomCefAttributes();
            result = result * 59 + ($customCefAttributes == null ? 43 : ((Object)$customCefAttributes).hashCode());
            return result;
        }

        public String toString() {
            return "CefAbacResponseMapper.Result(response=" + this.getResponse() + ", customCefAttributes=" + this.getCustomCefAttributes() + ")";
        }
    }

    public static final class Parameters {
        private final XacmlRequest request;
        private final XacmlResponse response;

        public Parameters(XacmlRequest request, XacmlResponse response) {
            this.request = request;
            this.response = response;
        }

        public XacmlRequest getRequest() {
            return this.request;
        }

        public XacmlResponse getResponse() {
            return this.response;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parameters)) {
                return false;
            }
            Parameters other = (Parameters)o;
            XacmlRequest this$request = this.getRequest();
            XacmlRequest other$request = other.getRequest();
            if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
                return false;
            }
            XacmlResponse this$response = this.getResponse();
            XacmlResponse other$response = other.getResponse();
            return !(this$response == null ? other$response != null : !((Object)this$response).equals(other$response));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            XacmlRequest $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            XacmlResponse $response = this.getResponse();
            result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
            return result;
        }

        public String toString() {
            return "CefAbacResponseMapper.Parameters(request=" + this.getRequest() + ", response=" + this.getResponse() + ")";
        }
    }
}

