/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.abac.cef;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;

public class CefEvent {
    private final String cefVersion;
    private final String applicationName;
    private final String logName;
    private final String logFormatVersion;
    private final String eventType;
    private final String description;
    private final Severity severity;
    private final Map<String, String> attributes;

    private CefEvent(@NonNull String cefVersion, @NonNull String applicationName, @NonNull String logName, @NonNull String logFormatVersion, @NonNull String eventType, @NonNull String description, @NonNull Severity severity, @NonNull Map<String, String> attributes) {
        if (cefVersion == null) {
            throw new NullPointerException("cefVersion is marked non-null but is null");
        }
        if (applicationName == null) {
            throw new NullPointerException("applicationName is marked non-null but is null");
        }
        if (logName == null) {
            throw new NullPointerException("logName is marked non-null but is null");
        }
        if (logFormatVersion == null) {
            throw new NullPointerException("logFormatVersion is marked non-null but is null");
        }
        if (eventType == null) {
            throw new NullPointerException("eventType is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (severity == null) {
            throw new NullPointerException("severity is marked non-null but is null");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        this.cefVersion = cefVersion;
        this.applicationName = applicationName;
        this.logName = logName;
        this.logFormatVersion = logFormatVersion;
        this.eventType = eventType;
        this.description = description;
        this.severity = severity;
        this.attributes = attributes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        String extension = this.attributes.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), this.escapeAttribute((String)entry.getValue()))).collect(Collectors.joining(" "));
        return String.format("CEF:%s|%s|%s|%s|%s|%s|%s|%s", this.escapeHeader(this.cefVersion), this.escapeHeader(this.applicationName), this.escapeHeader(this.logName), this.escapeHeader(this.logFormatVersion), this.escapeHeader(this.eventType), this.escapeHeader(this.description), this.severity.name(), extension);
    }

    private String escapeHeader(String header) {
        return header.replace("\\", "\\\\").replace("|", "\\|");
    }

    private String escapeAttribute(String attribute) {
        return attribute.replace("\\", "\\\\").replace("=", "\\=");
    }

    public static class Builder {
        private String cefVersion;
        private String applicationName;
        private String logName;
        private String logFormatVersion;
        private String eventType;
        private String description;
        private Severity severity;
        private final Map<String, String> attributes = new HashMap<String, String>();

        public Builder cefVersion(String cefVersion) {
            this.cefVersion = cefVersion;
            return this;
        }

        public Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public Builder logName(String logName) {
            this.logName = logName;
            return this;
        }

        public Builder logFormatVersion(String logFormatVersion) {
            this.logFormatVersion = logFormatVersion;
            return this;
        }

        public Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder addAttribute(String key, String value) {
            if (value != null) {
                this.attributes.put(key, value);
            }
            return this;
        }

        public CefEvent build() {
            return new CefEvent(this.cefVersion, this.applicationName, this.logName, this.logFormatVersion, this.eventType, this.description, this.severity, this.attributes);
        }
    }

    public static enum Severity {
        INFO,
        WARN;

    }
}

