/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.auth.oidc.discovery;

import no.nav.common.auth.oidc.discovery.OidcDiscoveryConfiguration;
import no.nav.common.rest.client.RestClient;
import no.nav.common.rest.client.RestUtils;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcDiscoveryConfigurationClient {
    private static final Logger log = LoggerFactory.getLogger(OidcDiscoveryConfigurationClient.class);
    private final OkHttpClient client;

    public OidcDiscoveryConfigurationClient() {
        this(RestClient.baseClient());
    }

    public OidcDiscoveryConfigurationClient(OkHttpClient client) {
        this.client = client;
    }

    public OidcDiscoveryConfiguration fetchDiscoveryConfiguration(String discoveryUrl) {
        OidcDiscoveryConfiguration oidcDiscoveryConfiguration;
        block11: {
            Request request = new Request.Builder().url(discoveryUrl).get().build();
            Response response = this.client.newCall(request).execute();
            try {
                oidcDiscoveryConfiguration = (OidcDiscoveryConfiguration)RestUtils.parseJsonResponseBodyOrThrow((ResponseBody)response.body(), OidcDiscoveryConfiguration.class);
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("Failed to retrieve discovery configuration from " + discoveryUrl, (Throwable)e);
                    throw e;
                }
            }
            response.close();
        }
        return oidcDiscoveryConfiguration;
    }
}

