/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.auth.oidc.filter;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import no.nav.common.auth.oidc.OidcTokenValidator;
import no.nav.common.auth.oidc.filter.OidcAuthenticatorConfig;
import no.nav.common.auth.utils.CookieUtils;

public final class OidcAuthenticator {
    public final OidcTokenValidator tokenValidator;
    public final OidcAuthenticatorConfig config;

    public static OidcAuthenticator fromConfig(OidcAuthenticatorConfig config) {
        if (!config.isValid()) {
            throw new IllegalStateException("OidcAuthenticatorConfig is missing one or more values");
        }
        OidcTokenValidator validator = new OidcTokenValidator(config.discoveryUrl, config.clientId);
        return new OidcAuthenticator(validator, config);
    }

    public Optional<String> findIdToken(HttpServletRequest request) {
        Optional<String> maybeIdTokenFromCookie = Optional.ofNullable(this.config.idTokenCookieName).flatMap(tokenName -> CookieUtils.getCookieValue(tokenName, request));
        if (maybeIdTokenFromCookie.isPresent()) {
            return maybeIdTokenFromCookie;
        }
        return this.config.idTokenFinder.findToken(request);
    }

    public Optional<String> findRefreshToken(HttpServletRequest request) {
        return Optional.ofNullable(this.config.refreshTokenCookieName).flatMap(tokenName -> CookieUtils.getCookieValue(tokenName, request));
    }

    public OidcAuthenticator(OidcTokenValidator tokenValidator, OidcAuthenticatorConfig config) {
        this.tokenValidator = tokenValidator;
        this.config = config;
    }

    public OidcTokenValidator getTokenValidator() {
        return this.tokenValidator;
    }

    public OidcAuthenticatorConfig getConfig() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OidcAuthenticator)) {
            return false;
        }
        OidcAuthenticator other = (OidcAuthenticator)o;
        OidcTokenValidator this$tokenValidator = this.getTokenValidator();
        OidcTokenValidator other$tokenValidator = other.getTokenValidator();
        if (this$tokenValidator == null ? other$tokenValidator != null : !this$tokenValidator.equals(other$tokenValidator)) {
            return false;
        }
        OidcAuthenticatorConfig this$config = this.getConfig();
        OidcAuthenticatorConfig other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !this$config.equals(other$config));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OidcTokenValidator $tokenValidator = this.getTokenValidator();
        result = result * 59 + ($tokenValidator == null ? 43 : $tokenValidator.hashCode());
        OidcAuthenticatorConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        return result;
    }

    public String toString() {
        return "OidcAuthenticator(tokenValidator=" + this.getTokenValidator() + ", config=" + this.getConfig() + ")";
    }
}

