/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.auth.oidc.filter;

import no.nav.common.auth.subject.IdentType;
import no.nav.common.auth.utils.AuthHeaderTokenFinder;
import no.nav.common.auth.utils.TokenFinder;

public class OidcAuthenticatorConfig {
    public String discoveryUrl;
    public String clientId;
    public IdentType identType;
    public String idTokenCookieName;
    public TokenFinder idTokenFinder = new AuthHeaderTokenFinder();
    public String refreshTokenCookieName;
    public String refreshUrl;

    public boolean isValid() {
        return this.discoveryUrl != null && this.clientId != null && this.identType != null && this.idTokenFinder != null;
    }

    public OidcAuthenticatorConfig withDiscoveryUrl(String discoveryUrl) {
        return this.discoveryUrl == discoveryUrl ? this : new OidcAuthenticatorConfig(discoveryUrl, this.clientId, this.identType, this.idTokenCookieName, this.idTokenFinder, this.refreshTokenCookieName, this.refreshUrl);
    }

    public OidcAuthenticatorConfig withClientId(String clientId) {
        return this.clientId == clientId ? this : new OidcAuthenticatorConfig(this.discoveryUrl, clientId, this.identType, this.idTokenCookieName, this.idTokenFinder, this.refreshTokenCookieName, this.refreshUrl);
    }

    public OidcAuthenticatorConfig withIdentType(IdentType identType) {
        return this.identType == identType ? this : new OidcAuthenticatorConfig(this.discoveryUrl, this.clientId, identType, this.idTokenCookieName, this.idTokenFinder, this.refreshTokenCookieName, this.refreshUrl);
    }

    public OidcAuthenticatorConfig withIdTokenCookieName(String idTokenCookieName) {
        return this.idTokenCookieName == idTokenCookieName ? this : new OidcAuthenticatorConfig(this.discoveryUrl, this.clientId, this.identType, idTokenCookieName, this.idTokenFinder, this.refreshTokenCookieName, this.refreshUrl);
    }

    public OidcAuthenticatorConfig withIdTokenFinder(TokenFinder idTokenFinder) {
        return this.idTokenFinder == idTokenFinder ? this : new OidcAuthenticatorConfig(this.discoveryUrl, this.clientId, this.identType, this.idTokenCookieName, idTokenFinder, this.refreshTokenCookieName, this.refreshUrl);
    }

    public OidcAuthenticatorConfig withRefreshTokenCookieName(String refreshTokenCookieName) {
        return this.refreshTokenCookieName == refreshTokenCookieName ? this : new OidcAuthenticatorConfig(this.discoveryUrl, this.clientId, this.identType, this.idTokenCookieName, this.idTokenFinder, refreshTokenCookieName, this.refreshUrl);
    }

    public OidcAuthenticatorConfig withRefreshUrl(String refreshUrl) {
        return this.refreshUrl == refreshUrl ? this : new OidcAuthenticatorConfig(this.discoveryUrl, this.clientId, this.identType, this.idTokenCookieName, this.idTokenFinder, this.refreshTokenCookieName, refreshUrl);
    }

    public OidcAuthenticatorConfig() {
    }

    public OidcAuthenticatorConfig(String discoveryUrl, String clientId, IdentType identType, String idTokenCookieName, TokenFinder idTokenFinder, String refreshTokenCookieName, String refreshUrl) {
        this.discoveryUrl = discoveryUrl;
        this.clientId = clientId;
        this.identType = identType;
        this.idTokenCookieName = idTokenCookieName;
        this.idTokenFinder = idTokenFinder;
        this.refreshTokenCookieName = refreshTokenCookieName;
        this.refreshUrl = refreshUrl;
    }
}

