/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.auth.subject;

import java.util.Collections;
import java.util.Map;
import no.nav.common.utils.AssertUtils;
import no.nav.common.utils.StringUtils;

public class SsoToken {
    private final Type type;
    private final String token;
    private final Map<String, Object> attributes;

    SsoToken(Type type, String token, Map<String, ?> attributes) {
        AssertUtils.assertNotNull((Object)((Object)type));
        StringUtils.assertNotNullOrEmpty((String)token);
        AssertUtils.assertNotNull(attributes);
        this.type = type;
        this.token = token;
        this.attributes = Collections.unmodifiableMap(attributes);
    }

    public static SsoToken oidcToken(String token, Map<String, ?> attributes) {
        return new SsoToken(Type.OIDC, token, attributes);
    }

    public static SsoToken saml(String samlAssertion, Map<String, ?> attributes) {
        return new SsoToken(Type.SAML, samlAssertion, attributes);
    }

    public static SsoToken eksternOpenAM(String token, Map<String, ?> attributes) {
        return new SsoToken(Type.EKSTERN_OPENAM, token, attributes);
    }

    public String toString() {
        return this.type.toString();
    }

    public Type getType() {
        return this.type;
    }

    public String getToken() {
        return this.token;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SsoToken)) {
            return false;
        }
        SsoToken other = (SsoToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        Map<String, Object> this$attributes = this.getAttributes();
        Map<String, Object> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SsoToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        Map<String, Object> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public static enum Type {
        OIDC,
        EKSTERN_OPENAM,
        SAML;

    }
}

