/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.auth.subject;

import java.util.Optional;
import no.nav.common.auth.subject.IdentType;
import no.nav.common.auth.subject.SsoToken;
import no.nav.common.utils.AssertUtils;
import no.nav.common.utils.StringUtils;

public final class Subject {
    private final String uid;
    private final IdentType identType;
    private final SsoToken ssoToken;

    public Subject(String uid, IdentType identType, SsoToken ssoToken) {
        StringUtils.assertNotNullOrEmpty((String)uid);
        AssertUtils.assertNotNull((Object)((Object)identType));
        AssertUtils.assertNotNull((Object)ssoToken);
        this.uid = uid;
        this.identType = identType;
        this.ssoToken = ssoToken;
    }

    public Optional<String> getSsoToken(SsoToken.Type type) {
        return this.ssoToken.getType() == type ? StringUtils.of((String)this.ssoToken.getToken()) : Optional.empty();
    }

    public String getUid() {
        return this.uid;
    }

    public IdentType getIdentType() {
        return this.identType;
    }

    public SsoToken getSsoToken() {
        return this.ssoToken;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subject)) {
            return false;
        }
        Subject other = (Subject)o;
        String this$uid = this.getUid();
        String other$uid = other.getUid();
        if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) {
            return false;
        }
        IdentType this$identType = this.getIdentType();
        IdentType other$identType = other.getIdentType();
        if (this$identType == null ? other$identType != null : !((Object)((Object)this$identType)).equals((Object)other$identType)) {
            return false;
        }
        SsoToken this$ssoToken = this.getSsoToken();
        SsoToken other$ssoToken = other.getSsoToken();
        return !(this$ssoToken == null ? other$ssoToken != null : !((Object)this$ssoToken).equals(other$ssoToken));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uid = this.getUid();
        result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
        IdentType $identType = this.getIdentType();
        result = result * 59 + ($identType == null ? 43 : ((Object)((Object)$identType)).hashCode());
        SsoToken $ssoToken = this.getSsoToken();
        result = result * 59 + ($ssoToken == null ? 43 : ((Object)$ssoToken).hashCode());
        return result;
    }

    public String toString() {
        return "Subject(uid=" + this.getUid() + ", identType=" + this.getIdentType() + ", ssoToken=" + this.getSsoToken() + ")";
    }

    public Subject withUid(String uid) {
        return this.uid == uid ? this : new Subject(uid, this.identType, this.ssoToken);
    }

    public Subject withIdentType(IdentType identType) {
        return this.identType == identType ? this : new Subject(this.uid, identType, this.ssoToken);
    }

    public Subject withSsoToken(SsoToken ssoToken) {
        return this.ssoToken == ssoToken ? this : new Subject(this.uid, this.identType, ssoToken);
    }
}

