/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.auth.subject;

import java.util.Optional;
import java.util.function.Supplier;
import no.nav.common.auth.subject.IdentType;
import no.nav.common.auth.subject.SsoToken;
import no.nav.common.auth.subject.Subject;
import no.nav.common.utils.fn.UnsafeRunnable;
import no.nav.common.utils.fn.UnsafeSupplier;

public class SubjectHandler {
    private static final SubjectStorage subjectStorage = new ThreadLocalSubjectStorage();

    public static void withSubject(Subject subject, UnsafeRunnable unsafeRunnable) {
        SubjectHandler.withSubject(subject, UnsafeSupplier.toVoid((UnsafeRunnable)unsafeRunnable));
    }

    public static <T> T withSubject(Subject subject, UnsafeSupplier<T> supplier) {
        Supplier<Subject> subjectSupplier = () -> subject;
        return SubjectHandler.withSubjectProvider(subjectSupplier, supplier);
    }

    public static void withSubjectProvider(Supplier<Subject> subjectSupplier, UnsafeRunnable unsafeRunnable) {
        SubjectHandler.withSubjectProvider(subjectSupplier, UnsafeSupplier.toVoid((UnsafeRunnable)unsafeRunnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withSubjectProvider(Supplier<Subject> currentSubjectSupplier, UnsafeSupplier<T> callback) {
        Supplier<Subject> previousSubjectSupplier = SubjectHandler.getSupplier();
        try {
            SubjectHandler.setSupplier(currentSubjectSupplier);
            Object object = callback.get();
            return (T)object;
        }
        finally {
            SubjectHandler.setSupplier(previousSubjectSupplier);
        }
    }

    protected static void setSupplier(Supplier<Subject> subjectSupplier) {
        subjectStorage.set(subjectSupplier);
    }

    protected static Supplier<Subject> getSupplier() {
        return subjectStorage.get();
    }

    public static Optional<Subject> getSubject() {
        return Optional.ofNullable(subjectStorage.get()).map(Supplier::get);
    }

    public static Optional<String> getIdent() {
        return SubjectHandler.getSubject().map(Subject::getUid);
    }

    public static Optional<IdentType> getIdentType() {
        return SubjectHandler.getSubject().map(Subject::getIdentType);
    }

    public static Optional<String> getSsoToken(SsoToken.Type type) {
        return SubjectHandler.getSubject().flatMap(s -> s.getSsoToken(type));
    }

    public static Optional<SsoToken> getSsoToken() {
        return SubjectHandler.getSubject().map(Subject::getSsoToken);
    }

    private static class ThreadLocalSubjectStorage
    implements SubjectStorage {
        private static final ThreadLocal<Supplier<Subject>> subjectHolder = new ThreadLocal();

        private ThreadLocalSubjectStorage() {
        }

        @Override
        public Supplier<Subject> get() {
            return subjectHolder.get();
        }

        @Override
        public void set(Supplier<Subject> subject) {
            subjectHolder.set(subject);
        }
    }

    public static interface SubjectStorage {
        public Supplier<Subject> get();

        public void set(Supplier<Subject> var1);
    }
}

