/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.auth.utils;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.Date;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import no.nav.common.auth.subject.IdentType;

public class TokenUtils {
    public static Optional<String> getTokenFromHeader(HttpServletRequest request) {
        String headerValue = request.getHeader("Authorization");
        return headerValue != null && !headerValue.isEmpty() && headerValue.startsWith("Bearer ") ? Optional.of(headerValue.substring("Bearer ".length())) : Optional.empty();
    }

    public static String getUid(JWT token, IdentType identType) throws ParseException {
        JWTClaimsSet claimsSet = token.getJWTClaimsSet();
        String subject = claimsSet.getSubject();
        if (identType == IdentType.InternBruker) {
            String navIdent = claimsSet.getStringClaim("NAVident");
            return navIdent != null ? navIdent : subject;
        }
        return subject;
    }

    public static boolean hasMatchingIssuer(JWT jwt, String issuer) {
        try {
            return jwt.getJWTClaimsSet().getIssuer().equals(issuer);
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean expiresWithin(JWT jwt, long withinMillis) {
        try {
            Date tokenExpiration = jwt.getJWTClaimsSet().getExpirationTime();
            long expirationTime = tokenExpiration.getTime() - withinMillis;
            return System.currentTimeMillis() > expirationTime;
        }
        catch (ParseException e) {
            return true;
        }
    }
}

