/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.auth.context;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import java.util.Optional;
import no.nav.common.auth.context.AuthContext;
import no.nav.common.auth.context.UserRole;
import no.nav.common.auth.utils.IdentUtils;
import no.nav.common.types.identer.NavIdent;
import no.nav.common.utils.fn.UnsafeRunnable;
import no.nav.common.utils.fn.UnsafeSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthContextHolder {
    private static final Logger log = LoggerFactory.getLogger(AuthContextHolder.class);
    private static final ThreadLocal<AuthContext> CONTEXT_HOLDER = new ThreadLocal();

    public static void withContext(AuthContext authContext, UnsafeRunnable runnable) {
        AuthContext previousContext = CONTEXT_HOLDER.get();
        try {
            CONTEXT_HOLDER.set(authContext);
            runnable.run();
        }
        finally {
            CONTEXT_HOLDER.set(previousContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withContext(AuthContext authContext, UnsafeSupplier<T> supplier) {
        AuthContext previousContext = CONTEXT_HOLDER.get();
        try {
            CONTEXT_HOLDER.set(authContext);
            Object object = supplier.get();
            return (T)object;
        }
        finally {
            CONTEXT_HOLDER.set(previousContext);
        }
    }

    public static NavIdent requireNavIdent() {
        return AuthContextHolder.getNavIdent().orElseThrow(() -> new IllegalStateException("NAV Ident is missing from AuthContext"));
    }

    public static String requireSubject() {
        return AuthContextHolder.getSubject().orElseThrow(() -> new IllegalStateException("Subject is missing from AuthContext"));
    }

    public static String requireIdTokenString() {
        return AuthContextHolder.getIdTokenString().orElseThrow(() -> new IllegalStateException("ID token is missing from AuthContext"));
    }

    public static JWTClaimsSet requireIdTokenClaims() {
        return AuthContextHolder.getIdTokenClaims().orElseThrow(() -> new IllegalStateException("ID token is missing from AuthContext"));
    }

    public static UserRole requireRole() {
        return AuthContextHolder.getRole().orElseThrow(() -> new IllegalStateException("User role is missing from AuthContext"));
    }

    public static AuthContext requireContext() {
        return AuthContextHolder.getContext().orElseThrow(() -> new IllegalStateException("AuthContext is missing"));
    }

    public static Optional<String> getSubject() {
        return AuthContextHolder.getIdTokenClaims().map(JWTClaimsSet::getSubject);
    }

    public static Optional<String> getIdTokenString() {
        return AuthContextHolder.getContext().map(AuthContext::getIdToken).map(token -> Optional.ofNullable(token.getParsedString()).orElse(token.serialize()));
    }

    public static Optional<JWTClaimsSet> getIdTokenClaims() {
        return AuthContextHolder.getContext().map(AuthContext::getIdToken).map(AuthContextHolder::getClaimsSet);
    }

    public static Optional<NavIdent> getNavIdent() {
        return AuthContextHolder.getIdTokenClaims().flatMap(claims -> {
            try {
                return Optional.ofNullable(claims.getStringClaim("NAVident")).map(NavIdent::of).or(() -> AuthContextHolder.getSubject().map(NavIdent::of));
            }
            catch (Exception e) {
                log.warn("NAVident was not a string");
                return Optional.empty();
            }
        }).filter(navIdent -> {
            boolean erGyldig = IdentUtils.erGydligNavIdent(navIdent.get());
            if (!erGyldig) {
                log.error("NAV ident er ugyldig: " + navIdent);
            }
            return erGyldig;
        });
    }

    public static Optional<UserRole> getRole() {
        return AuthContextHolder.getContext().map(AuthContext::getRole);
    }

    public static Optional<AuthContext> getContext() {
        return Optional.ofNullable(CONTEXT_HOLDER.get());
    }

    public static void setContext(AuthContext authContext) {
        CONTEXT_HOLDER.set(authContext);
    }

    public static boolean erInternBruker() {
        return AuthContextHolder.harBrukerRolle(UserRole.INTERN);
    }

    public static boolean erSystemBruker() {
        return AuthContextHolder.harBrukerRolle(UserRole.SYSTEM);
    }

    public static boolean erEksternBruker() {
        return AuthContextHolder.harBrukerRolle(UserRole.EKSTERN);
    }

    public static boolean harBrukerRolle(UserRole userRole) {
        return AuthContextHolder.getRole().map(role -> role == userRole).orElse(false);
    }

    private static JWTClaimsSet getClaimsSet(JWT jwt) {
        return jwt.getJWTClaimsSet();
    }
}

