/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.auth.oidc;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.validators.IDTokenValidator;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import no.nav.common.auth.oidc.discovery.OidcDiscoveryConfiguration;
import no.nav.common.auth.oidc.discovery.OidcDiscoveryConfigurationClient;

public class OidcTokenValidator {
    private static final JWSAlgorithm JWS_ALGORITHM = JWSAlgorithm.RS256;
    private final HashMap<String, IDTokenValidator> validators;
    private final String issuer;

    public OidcTokenValidator(String oidcDiscoveryUrl, List<String> clientIds) {
        OidcDiscoveryConfigurationClient client = new OidcDiscoveryConfigurationClient();
        OidcDiscoveryConfiguration config = client.fetchDiscoveryConfiguration(oidcDiscoveryUrl);
        this.issuer = config.issuer;
        this.validators = new HashMap();
        clientIds.forEach(id -> this.validators.put((String)id, this.createValidator(config.issuer, config.jwksUri, JWS_ALGORITHM, (String)id)));
    }

    public IDTokenClaimsSet validate(JWT idToken) throws BadJOSEException, JOSEException, ParseException {
        JWTClaimsSet claims = idToken.getJWTClaimsSet();
        List tokenAudiences = claims.getAudience();
        String clientId = tokenAudiences.size() > 1 ? claims.getStringClaim("azp") : (String)tokenAudiences.get(0);
        IDTokenValidator validator = this.validators.get(clientId);
        if (validator == null) {
            throw new RuntimeException("Could not find validator for audience " + clientId);
        }
        return validator.validate(idToken, null);
    }

    public IDTokenClaimsSet validate(String token) throws ParseException, JOSEException, BadJOSEException {
        return this.validate(JWTParser.parse((String)token));
    }

    public String getIssuer() {
        return this.issuer;
    }

    private IDTokenValidator createValidator(String issuerUrl, String jwksUrl, JWSAlgorithm algorithm, String clientId) {
        Issuer issuer = new Issuer(issuerUrl);
        ClientID clientID = new ClientID(clientId);
        try {
            return new IDTokenValidator(issuer, clientID, algorithm, new URL(jwksUrl));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid jwks URL " + jwksUrl);
        }
    }
}

