/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.auth.oidc;

import no.nav.common.rest.client.RestClient;
import no.nav.common.rest.client.RestUtils;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenRefreshClient {
    private static final Logger log = LoggerFactory.getLogger(TokenRefreshClient.class);
    private final OkHttpClient client;

    public TokenRefreshClient() {
        this(RestClient.baseClient());
    }

    public TokenRefreshClient(OkHttpClient client) {
        this.client = client;
    }

    public String refreshIdToken(String refreshUrl, String refreshToken) {
        String string;
        block12: {
            Request request = new Request.Builder().url(refreshUrl).post(RestUtils.toJsonRequestBody((Object)new RefreshIdTokenRequest(refreshToken))).build();
            Response response = this.client.newCall(request).execute();
            try {
                if (response.code() >= 300) {
                    String responseStr = RestUtils.getBodyStr((Response)response).orElse("");
                    throw new RuntimeException(String.format("Received unexpected status %d from %s when refreshing id token. Response: %s", response.code(), refreshUrl, responseStr));
                }
                string = ((RefreshIdTokenResponse)RestUtils.parseJsonResponseOrThrow((Response)response, RefreshIdTokenResponse.class)).idToken;
                if (response == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("Failed to refresh token with URL " + refreshUrl, (Throwable)e);
                    throw e;
                }
            }
            response.close();
        }
        return string;
    }

    public static class RefreshIdTokenResponse {
        public String idToken;

        public RefreshIdTokenResponse() {
        }

        public RefreshIdTokenResponse(String idToken) {
            this.idToken = idToken;
        }
    }

    public static class RefreshIdTokenRequest {
        public String refreshToken;

        public RefreshIdTokenRequest() {
        }

        public RefreshIdTokenRequest(String refreshToken) {
            this.refreshToken = refreshToken;
        }
    }
}

