/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.auth.oidc.filter;

import java.util.Collections;
import java.util.List;
import no.nav.common.auth.context.UserRole;
import no.nav.common.auth.utils.AuthHeaderTokenFinder;
import no.nav.common.auth.utils.TokenFinder;

public class OidcAuthenticatorConfig {
    public String discoveryUrl;
    public List<String> clientIds;
    public UserRole userRole;
    public String idTokenCookieName;
    public TokenFinder idTokenFinder = new AuthHeaderTokenFinder();
    public String refreshTokenCookieName;
    public String refreshUrl;

    public boolean isValid() {
        return this.discoveryUrl != null && this.clientIds != null && this.userRole != null && this.idTokenFinder != null;
    }

    public OidcAuthenticatorConfig withClientId(String clientId) {
        this.clientIds = Collections.singletonList(clientId);
        return this;
    }

    public OidcAuthenticatorConfig withDiscoveryUrl(String discoveryUrl) {
        return this.discoveryUrl == discoveryUrl ? this : new OidcAuthenticatorConfig(discoveryUrl, this.clientIds, this.userRole, this.idTokenCookieName, this.idTokenFinder, this.refreshTokenCookieName, this.refreshUrl);
    }

    public OidcAuthenticatorConfig withClientIds(List<String> clientIds) {
        return this.clientIds == clientIds ? this : new OidcAuthenticatorConfig(this.discoveryUrl, clientIds, this.userRole, this.idTokenCookieName, this.idTokenFinder, this.refreshTokenCookieName, this.refreshUrl);
    }

    public OidcAuthenticatorConfig withUserRole(UserRole userRole) {
        return this.userRole == userRole ? this : new OidcAuthenticatorConfig(this.discoveryUrl, this.clientIds, userRole, this.idTokenCookieName, this.idTokenFinder, this.refreshTokenCookieName, this.refreshUrl);
    }

    public OidcAuthenticatorConfig withIdTokenCookieName(String idTokenCookieName) {
        return this.idTokenCookieName == idTokenCookieName ? this : new OidcAuthenticatorConfig(this.discoveryUrl, this.clientIds, this.userRole, idTokenCookieName, this.idTokenFinder, this.refreshTokenCookieName, this.refreshUrl);
    }

    public OidcAuthenticatorConfig withIdTokenFinder(TokenFinder idTokenFinder) {
        return this.idTokenFinder == idTokenFinder ? this : new OidcAuthenticatorConfig(this.discoveryUrl, this.clientIds, this.userRole, this.idTokenCookieName, idTokenFinder, this.refreshTokenCookieName, this.refreshUrl);
    }

    public OidcAuthenticatorConfig withRefreshTokenCookieName(String refreshTokenCookieName) {
        return this.refreshTokenCookieName == refreshTokenCookieName ? this : new OidcAuthenticatorConfig(this.discoveryUrl, this.clientIds, this.userRole, this.idTokenCookieName, this.idTokenFinder, refreshTokenCookieName, this.refreshUrl);
    }

    public OidcAuthenticatorConfig withRefreshUrl(String refreshUrl) {
        return this.refreshUrl == refreshUrl ? this : new OidcAuthenticatorConfig(this.discoveryUrl, this.clientIds, this.userRole, this.idTokenCookieName, this.idTokenFinder, this.refreshTokenCookieName, refreshUrl);
    }

    public OidcAuthenticatorConfig() {
    }

    public OidcAuthenticatorConfig(String discoveryUrl, List<String> clientIds, UserRole userRole, String idTokenCookieName, TokenFinder idTokenFinder, String refreshTokenCookieName, String refreshUrl) {
        this.discoveryUrl = discoveryUrl;
        this.clientIds = clientIds;
        this.userRole = userRole;
        this.idTokenCookieName = idTokenCookieName;
        this.idTokenFinder = idTokenFinder;
        this.refreshTokenCookieName = refreshTokenCookieName;
        this.refreshUrl = refreshUrl;
    }
}

