/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.auth.utils;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenUtils {
    private static final Logger log = LoggerFactory.getLogger(TokenUtils.class);

    public static Optional<String> getTokenFromHeader(HttpServletRequest request) {
        String headerValue = request.getHeader("Authorization");
        return headerValue != null && !headerValue.isEmpty() && headerValue.startsWith("Bearer ") ? Optional.of(headerValue.substring("Bearer ".length())) : Optional.empty();
    }

    public static boolean hasMatchingAudience(JWT jwtToken, List<String> audiences) {
        try {
            List tokenAudiences = jwtToken.getJWTClaimsSet().getAudience();
            return tokenAudiences.stream().anyMatch(audiences::contains);
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean hasMatchingIssuer(JWT jwt, String issuer) {
        try {
            return jwt.getJWTClaimsSet().getIssuer().equals(issuer);
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isServiceUserToken(String oidcToken) {
        try {
            JWT jwt = JWTParser.parse((String)oidcToken);
            String subject = jwt.getJWTClaimsSet().getSubject();
            return subject.startsWith("srv");
        }
        catch (ParseException e) {
            log.error("Failed to parse token", (Throwable)e);
            throw new RuntimeException("Unable to verify service user. Failed to parse token");
        }
    }

    public static boolean expiresWithin(JWT jwt, long withinMillis) {
        try {
            Date tokenExpiration = jwt.getJWTClaimsSet().getExpirationTime();
            long expirationTime = tokenExpiration.getTime() - withinMillis;
            return System.currentTimeMillis() > expirationTime;
        }
        catch (ParseException e) {
            return true;
        }
    }
}

