/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.client.aktoroppslag;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import no.nav.common.client.aktoroppslag.AktorOppslagClient;
import no.nav.common.client.utils.CacheUtils;
import no.nav.common.health.HealthCheckResult;
import no.nav.common.types.identer.AktorId;
import no.nav.common.types.identer.Fnr;

public class CachedAktorOppslagClient
implements AktorOppslagClient {
    private final AktorOppslagClient aktorOppslagClient;
    private final Cache<AktorId, Fnr> hentFnrCache;
    private final Cache<Fnr, AktorId> hentAktorIdCache;

    public CachedAktorOppslagClient(AktorOppslagClient aktorOppslagClient, Cache<AktorId, Fnr> hentFnrCache, Cache<Fnr, AktorId> hentAktorIdCache) {
        this.aktorOppslagClient = aktorOppslagClient;
        this.hentFnrCache = hentFnrCache;
        this.hentAktorIdCache = hentAktorIdCache;
    }

    public CachedAktorOppslagClient(AktorOppslagClient aktorOppslagClient) {
        this.aktorOppslagClient = aktorOppslagClient;
        this.hentFnrCache = Caffeine.newBuilder().expireAfterWrite(12L, TimeUnit.HOURS).maximumSize(10000L).build();
        this.hentAktorIdCache = Caffeine.newBuilder().expireAfterWrite(12L, TimeUnit.HOURS).maximumSize(10000L).build();
    }

    @Override
    public Fnr hentFnr(AktorId aktorId) {
        return CacheUtils.tryCacheFirst(this.hentFnrCache, aktorId, () -> this.aktorOppslagClient.hentFnr(aktorId));
    }

    @Override
    public AktorId hentAktorId(Fnr fnr) {
        return CacheUtils.tryCacheFirst(this.hentAktorIdCache, fnr, () -> this.aktorOppslagClient.hentAktorId(fnr));
    }

    @Override
    public Map<AktorId, Fnr> hentFnrBolk(List<AktorId> aktorIdListe) {
        HashMap<AktorId, Fnr> aktorIdTilFnrMap = new HashMap<AktorId, Fnr>();
        ArrayList<AktorId> uncachedAktorIds = new ArrayList<AktorId>();
        aktorIdListe.forEach(aktorId -> {
            Fnr fnr = (Fnr)this.hentFnrCache.getIfPresent(aktorId);
            if (fnr != null) {
                aktorIdTilFnrMap.put((AktorId)aktorId, fnr);
            } else {
                uncachedAktorIds.add((AktorId)aktorId);
            }
        });
        if (!uncachedAktorIds.isEmpty()) {
            Map<AktorId, Fnr> identOppslag = this.aktorOppslagClient.hentFnrBolk(uncachedAktorIds);
            identOppslag.forEach((arg_0, arg_1) -> this.hentFnrCache.put(arg_0, arg_1));
            aktorIdTilFnrMap.putAll(identOppslag);
        }
        return aktorIdTilFnrMap;
    }

    @Override
    public Map<Fnr, AktorId> hentAktorIdBolk(List<Fnr> fnrListe) {
        HashMap<Fnr, AktorId> fnrTilAktorIdMap = new HashMap<Fnr, AktorId>();
        ArrayList<Fnr> uncachedFnrs = new ArrayList<Fnr>();
        fnrListe.forEach(fnr -> {
            AktorId aktorId = (AktorId)this.hentAktorIdCache.getIfPresent(fnr);
            if (aktorId != null) {
                fnrTilAktorIdMap.put((Fnr)fnr, aktorId);
            } else {
                uncachedFnrs.add((Fnr)fnr);
            }
        });
        if (!uncachedFnrs.isEmpty()) {
            Map<Fnr, AktorId> identOppslag = this.aktorOppslagClient.hentAktorIdBolk(uncachedFnrs);
            identOppslag.forEach((arg_0, arg_1) -> this.hentAktorIdCache.put(arg_0, arg_1));
            fnrTilAktorIdMap.putAll(identOppslag);
        }
        return fnrTilAktorIdMap;
    }

    public HealthCheckResult checkHealth() {
        return this.aktorOppslagClient.checkHealth();
    }
}

