/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.client.aktoroppslag;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.nav.common.client.aktoroppslag.AktorOppslagClient;
import no.nav.common.client.pdl.PdlClient;
import no.nav.common.client.pdl.PdlClientImpl;
import no.nav.common.client.pdl.Tema;
import no.nav.common.client.utils.graphql.GraphqlRequestBuilder;
import no.nav.common.client.utils.graphql.GraphqlResponse;
import no.nav.common.client.utils.graphql.GraphqlUtils;
import no.nav.common.health.HealthCheckResult;
import no.nav.common.types.identer.AktorId;
import no.nav.common.types.identer.EksternBrukerId;
import no.nav.common.types.identer.Fnr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdlAktorOppslagClient
implements AktorOppslagClient {
    private static final Logger log = LoggerFactory.getLogger(PdlAktorOppslagClient.class);
    private static final String IDENT_GRUPPE_AKTORID = "AKTORID";
    private static final String IDENT_GRUPPE_FNR = "FOLKEREGISTERIDENT";
    private final GraphqlRequestBuilder<HentIdentVariables> hentAktorIdRequestBuilder = new GraphqlRequestBuilder("pdl/hent-gjeldende-aktorid.graphql");
    private final GraphqlRequestBuilder<HentIdentVariables> hentFnrRequestBuilder = new GraphqlRequestBuilder("pdl/hent-gjeldende-fnr.graphql");
    private final GraphqlRequestBuilder<HentIdentBolkVariables<?>> hentIdentBolkRequestBuilder = new GraphqlRequestBuilder("pdl/hent-gjeldende-ident-bolk.graphql");
    private final PdlClient pdlClient;

    public PdlAktorOppslagClient(String pdlUrl, Supplier<String> userTokenSupplier, Supplier<String> consumerTokenSupplier) {
        this.pdlClient = new PdlClientImpl(pdlUrl, Tema.GEN, userTokenSupplier, consumerTokenSupplier);
    }

    public PdlAktorOppslagClient(PdlClient pdlClient) {
        this.pdlClient = pdlClient;
    }

    @Override
    public Fnr hentFnr(AktorId aktorId) {
        HentIdenterResponse response = this.pdlClient.request(this.hentFnrRequestBuilder.buildRequest(new HentIdentVariables(aktorId.get())), HentIdenterResponse.class);
        GraphqlUtils.throwIfErrorOrMissingData(response);
        return ((HentIdenterResponse.HentIdenterResponseData)response.getData()).hentIdenter.identer.stream().findFirst().map(identData -> Fnr.of((String)identData.ident)).orElseThrow();
    }

    @Override
    public AktorId hentAktorId(Fnr fnr) {
        HentIdenterResponse response = this.pdlClient.request(this.hentAktorIdRequestBuilder.buildRequest(new HentIdentVariables(fnr.get())), HentIdenterResponse.class);
        GraphqlUtils.throwIfErrorOrMissingData(response);
        return ((HentIdenterResponse.HentIdenterResponseData)response.getData()).hentIdenter.identer.stream().findFirst().map(identData -> AktorId.of((String)identData.ident)).orElseThrow();
    }

    @Override
    public Map<AktorId, Fnr> hentFnrBolk(List<AktorId> aktorIdListe) {
        HentIdenterBolkResponse response = this.pdlClient.request(this.hentIdentBolkRequestBuilder.buildRequest(new HentIdentBolkVariables<AktorId>(aktorIdListe)), HentIdenterBolkResponse.class);
        GraphqlUtils.throwIfErrorOrMissingData(response);
        return PdlAktorOppslagClient.hentAlleIdentPairFraBolk((HentIdenterBolkResponse.HentIdenterBolkResponseData)response.getData()).collect(Collectors.toMap(IdentPair::getAktorId, IdentPair::getFnr));
    }

    @Override
    public Map<Fnr, AktorId> hentAktorIdBolk(List<Fnr> fnrListe) {
        HentIdenterBolkResponse response = this.pdlClient.request(this.hentIdentBolkRequestBuilder.buildRequest(new HentIdentBolkVariables<Fnr>(fnrListe)), HentIdenterBolkResponse.class);
        GraphqlUtils.throwIfErrorOrMissingData(response);
        return PdlAktorOppslagClient.hentAlleIdentPairFraBolk((HentIdenterBolkResponse.HentIdenterBolkResponseData)response.getData()).collect(Collectors.toMap(IdentPair::getFnr, IdentPair::getAktorId));
    }

    private static Stream<IdentPair> hentAlleIdentPairFraBolk(HentIdenterBolkResponse.HentIdenterBolkResponseData bolkResponseData) {
        return bolkResponseData.hentIdenterBolk.stream().filter(identData -> identData.identer != null).map(identData -> PdlAktorOppslagClient.mergeIdenterTilPair(identData.identer));
    }

    private static IdentPair mergeIdenterTilPair(List<HentIdenterBolkResponse.HentIdenterBolkResponseData.IdenterResponseData.IdentData> brukerIdenter) {
        IdentPair identPair = new IdentPair();
        brukerIdenter.forEach(ident -> {
            switch (ident.gruppe) {
                case "FOLKEREGISTERIDENT": {
                    identPair.setFnr(Fnr.of((String)ident.ident));
                    break;
                }
                case "AKTORID": {
                    identPair.setAktorId(AktorId.of((String)ident.ident));
                }
            }
        });
        return identPair;
    }

    public HealthCheckResult checkHealth() {
        return this.pdlClient.checkHealth();
    }

    static class HentIdenterBolkResponse
    extends GraphqlResponse<HentIdenterBolkResponseData> {
        HentIdenterBolkResponse() {
        }

        private static class HentIdenterBolkResponseData {
            List<IdenterResponseData> hentIdenterBolk;

            private HentIdenterBolkResponseData() {
            }

            private static class IdenterResponseData {
                List<IdentData> identer;

                private IdenterResponseData() {
                }

                private static class IdentData {
                    String ident;
                    String gruppe;

                    private IdentData() {
                    }
                }
            }
        }
    }

    static class HentIdenterResponse
    extends GraphqlResponse<HentIdenterResponseData> {
        HentIdenterResponse() {
        }

        private static class HentIdenterResponseData {
            IdenterResponseData hentIdenter;

            private HentIdenterResponseData() {
            }

            private static class IdenterResponseData {
                List<IdentData> identer;

                private IdenterResponseData() {
                }

                private static class IdentData {
                    String ident;

                    private IdentData() {
                    }
                }
            }
        }
    }

    private static final class HentIdentBolkVariables<T extends EksternBrukerId> {
        private final List<T> identer;

        public HentIdentBolkVariables(List<T> identer) {
            this.identer = identer;
        }

        public List<T> getIdenter() {
            return this.identer;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HentIdentBolkVariables)) {
                return false;
            }
            HentIdentBolkVariables other = (HentIdentBolkVariables)o;
            List<T> this$identer = this.getIdenter();
            List<T> other$identer = other.getIdenter();
            return !(this$identer == null ? other$identer != null : !((Object)this$identer).equals(other$identer));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<T> $identer = this.getIdenter();
            result = result * 59 + ($identer == null ? 43 : ((Object)$identer).hashCode());
            return result;
        }

        public String toString() {
            return "PdlAktorOppslagClient.HentIdentBolkVariables(identer=" + this.getIdenter() + ")";
        }
    }

    private static final class HentIdentVariables {
        private final String ident;

        public HentIdentVariables(String ident) {
            this.ident = ident;
        }

        public String getIdent() {
            return this.ident;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HentIdentVariables)) {
                return false;
            }
            HentIdentVariables other = (HentIdentVariables)o;
            String this$ident = this.getIdent();
            String other$ident = other.getIdent();
            return !(this$ident == null ? other$ident != null : !this$ident.equals(other$ident));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $ident = this.getIdent();
            result = result * 59 + ($ident == null ? 43 : $ident.hashCode());
            return result;
        }

        public String toString() {
            return "PdlAktorOppslagClient.HentIdentVariables(ident=" + this.getIdent() + ")";
        }
    }

    private static class IdentPair {
        AktorId aktorId;
        Fnr fnr;

        public AktorId getAktorId() {
            return this.aktorId;
        }

        public Fnr getFnr() {
            return this.fnr;
        }

        public void setAktorId(AktorId aktorId) {
            this.aktorId = aktorId;
        }

        public void setFnr(Fnr fnr) {
            this.fnr = fnr;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IdentPair)) {
                return false;
            }
            IdentPair other = (IdentPair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AktorId this$aktorId = this.getAktorId();
            AktorId other$aktorId = other.getAktorId();
            if (this$aktorId == null ? other$aktorId != null : !this$aktorId.equals(other$aktorId)) {
                return false;
            }
            Fnr this$fnr = this.getFnr();
            Fnr other$fnr = other.getFnr();
            return !(this$fnr == null ? other$fnr != null : !this$fnr.equals(other$fnr));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IdentPair;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AktorId $aktorId = this.getAktorId();
            result = result * 59 + ($aktorId == null ? 43 : $aktorId.hashCode());
            Fnr $fnr = this.getFnr();
            result = result * 59 + ($fnr == null ? 43 : $fnr.hashCode());
            return result;
        }

        public String toString() {
            return "PdlAktorOppslagClient.IdentPair(aktorId=" + this.getAktorId() + ", fnr=" + this.getFnr() + ")";
        }
    }
}

