/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.client.aktorregister;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import no.nav.common.client.aktorregister.AktorregisterClient;
import no.nav.common.health.HealthCheckResult;
import no.nav.common.health.HealthCheckUtils;
import no.nav.common.json.JsonUtils;
import no.nav.common.rest.client.RestClient;
import no.nav.common.rest.client.RestUtils;
import no.nav.common.types.identer.AktorId;
import no.nav.common.types.identer.EksternBrukerId;
import no.nav.common.types.identer.Fnr;
import no.nav.common.types.identer.Id;
import no.nav.common.utils.UrlUtils;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AktorregisterHttpClient
implements AktorregisterClient {
    private static final Logger log = LoggerFactory.getLogger(AktorregisterHttpClient.class);
    private static final MapType mapType = JsonUtils.getMapper().getTypeFactory().constructMapType(HashMap.class, String.class, IdentData.class);
    private final String aktorregisterUrl;
    private final String aktorregisterIsAliveUrl;
    private final String consumingApplication;
    private final Supplier<String> tokenSupplier;
    private final OkHttpClient client;

    public AktorregisterHttpClient(String aktorregisterUrl, String consumingApplication, Supplier<String> tokenSupplier) {
        this.aktorregisterUrl = aktorregisterUrl;
        this.aktorregisterIsAliveUrl = this.resolveIsAliveUrl(aktorregisterUrl);
        this.consumingApplication = consumingApplication;
        this.tokenSupplier = tokenSupplier;
        this.client = RestClient.baseClient();
    }

    @Override
    public Fnr hentFnr(AktorId aktorId) {
        return Fnr.of((String)this.hentEnkeltIdent((EksternBrukerId)aktorId, Identgruppe.NorskIdent));
    }

    @Override
    public AktorId hentAktorId(Fnr fnr) {
        return AktorId.of((String)this.hentEnkeltIdent((EksternBrukerId)fnr, Identgruppe.AktoerId));
    }

    @Override
    public Map<AktorId, Fnr> hentFnrBolk(List<AktorId> aktorIdListe) {
        Map<String, IdentData> oppslagMap = this.hentIdenter(aktorIdListe, Identgruppe.AktoerId, true);
        HashMap<AktorId, Fnr> aktorIdToFnrMap = new HashMap<AktorId, Fnr>();
        oppslagMap.entrySet().stream().map(this::tilIdentOppslag).forEach(oppslag -> {
            AktorId aktorId = AktorId.of((String)oppslag.getIdentTilRegister());
            Optional<Fnr> maybeFnr = oppslag.getIdentFraRegister().map(Fnr::of);
            maybeFnr.ifPresent(fnr -> aktorIdToFnrMap.put(aktorId, (Fnr)fnr));
        });
        return aktorIdToFnrMap;
    }

    @Override
    public Map<Fnr, AktorId> hentAktorIdBolk(List<Fnr> fnrListe) {
        Map<String, IdentData> oppslagMap = this.hentIdenter(fnrListe, Identgruppe.AktoerId, true);
        HashMap<Fnr, AktorId> fnrToAktorIdMap = new HashMap<Fnr, AktorId>();
        oppslagMap.entrySet().stream().map(this::tilIdentOppslag).forEach(oppslag -> {
            Fnr fnr = Fnr.of((String)oppslag.getIdentTilRegister());
            Optional<AktorId> maybeAktorId = oppslag.getIdentFraRegister().map(AktorId::of);
            maybeAktorId.ifPresent(aktorId -> fnrToAktorIdMap.put(fnr, (AktorId)aktorId));
        });
        return fnrToAktorIdMap;
    }

    @Override
    public List<AktorId> hentAktorIder(Fnr fnr) {
        return this.hentIdenter(Collections.singletonList(fnr), Identgruppe.AktoerId, false).entrySet().stream().flatMap(e -> Optional.ofNullable(((IdentData)e.getValue()).identer).orElseThrow(() -> new RuntimeException("Akt\u00f8r registeret feilet og fant ikke identer p\u00e5 bruker")).stream().filter(i -> i.identgruppe == Identgruppe.AktoerId && i.ident != null).map(i -> AktorId.of((String)i.ident))).collect(Collectors.toList());
    }

    private String hentEnkeltIdent(EksternBrukerId eksternBrukerId, Identgruppe identgruppe) {
        return this.hentIdenter(Collections.singletonList(eksternBrukerId), identgruppe, true).entrySet().stream().filter(this::filtrerIkkeGjeldendeIdent).findFirst().flatMap(e -> this.finnGjeldendeIdent(((IdentData)e.getValue()).identer)).map(i -> i.ident).orElseThrow(() -> new RuntimeException("Fant ikke gjeldende ident"));
    }

    private String createRequestUrl(String aktorregisterUrl, Identgruppe identgruppe, boolean gjeldende) {
        if (gjeldende) {
            return String.format("%s/identer?gjeldende=true&identgruppe=%s", aktorregisterUrl, String.valueOf((Object)identgruppe));
        }
        return String.format("%s/identer?identgruppe=%s", aktorregisterUrl, String.valueOf((Object)identgruppe));
    }

    private boolean filtrerIkkeGjeldendeIdent(Map.Entry<String, IdentData> identEntry) {
        List<Ident> identer = identEntry.getValue().identer;
        return identer != null && this.finnGjeldendeIdent(identer).isPresent();
    }

    private Optional<Ident> finnGjeldendeIdent(List<Ident> identer) {
        return identer.stream().filter(ident -> ident.gjeldende).findFirst();
    }

    private IdentOppslag tilIdentOppslag(Map.Entry<String, IdentData> identEntry) {
        Optional<Ident> gjeldendeIdent = this.finnGjeldendeIdent(identEntry.getValue().identer);
        return new IdentOppslag(identEntry.getKey(), gjeldendeIdent.map(i -> i.ident).orElse(null));
    }

    private <T extends EksternBrukerId> Map<String, IdentData> hentIdenter(List<T> eksternBrukerIdList, Identgruppe identgruppe, boolean gjeldende) throws IOException {
        Map map;
        block10: {
            String personidenter = eksternBrukerIdList.stream().map(Id::get).collect(Collectors.joining(","));
            String requestUrl = this.createRequestUrl(this.aktorregisterUrl, identgruppe, gjeldende);
            Request request = new Request.Builder().url(requestUrl).addHeader("Nav-Call-Id", UUID.randomUUID().toString()).addHeader("Nav-Consumer-Id", this.consumingApplication).addHeader("Nav-Personidenter", personidenter).addHeader("Authorization", "Bearer " + this.tokenSupplier.get()).build();
            Response response = this.client.newCall(request).execute();
            try {
                if (response.code() >= 300) {
                    String responseStr = RestUtils.getBodyStr((Response)response).orElse("");
                    throw new RuntimeException(String.format("Fikk uventet status %d fra %s. Respons: %s", response.code(), request, responseStr));
                }
                Optional jsonStr = RestUtils.getBodyStr((Response)response);
                if (jsonStr.isEmpty()) {
                    throw new IllegalStateException("Respons mangler body");
                }
                map = (Map)JsonUtils.getMapper().readValue((String)jsonStr.get(), (JavaType)mapType);
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("Klarte ikke \u00e5 gjore oppslag mot aktorregister", (Throwable)e);
                    throw e;
                }
            }
            response.close();
        }
        return map;
    }

    public HealthCheckResult checkHealth() {
        return HealthCheckUtils.pingUrl((String)this.aktorregisterIsAliveUrl, (OkHttpClient)this.client);
    }

    private String resolveIsAliveUrl(String apiUrl) {
        String baseUrl = apiUrl;
        if (apiUrl.endsWith("api/v1")) {
            baseUrl = apiUrl.replace("api/v1", "");
        }
        return UrlUtils.joinPaths((String[])new String[]{baseUrl, "/internal/isAlive"});
    }

    private static class IdentOppslag {
        private String identTilRegister;
        private String identFraRegister;

        public IdentOppslag(String identTilRegister, String identFraRegister) {
            this.identTilRegister = identTilRegister;
            this.identFraRegister = identFraRegister;
        }

        public String getIdentTilRegister() {
            return this.identTilRegister;
        }

        public Optional<String> getIdentFraRegister() {
            return Optional.ofNullable(this.identFraRegister);
        }
    }

    private static class Ident {
        public String ident;
        public Identgruppe identgruppe;
        public boolean gjeldende;

        private Ident() {
        }
    }

    private static class IdentData {
        public List<Ident> identer;
        public String feilmelding;

        private IdentData() {
        }
    }

    static enum Identgruppe {
        NorskIdent,
        AktoerId;

    }
}

