/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.client.axsys;

import java.util.List;
import java.util.stream.Collectors;
import no.nav.common.client.axsys.AxsysClient;
import no.nav.common.client.axsys.AxsysEnhet;
import no.nav.common.health.HealthCheckResult;
import no.nav.common.health.HealthCheckUtils;
import no.nav.common.rest.client.RestClient;
import no.nav.common.rest.client.RestUtils;
import no.nav.common.types.identer.EnhetId;
import no.nav.common.types.identer.NavIdent;
import no.nav.common.utils.UrlUtils;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class AxsysClientImpl
implements AxsysClient {
    private final OkHttpClient client;
    private final String axsysUrl;

    public AxsysClientImpl(String axsysUrl) {
        this.axsysUrl = axsysUrl;
        this.client = RestClient.baseClient();
    }

    public AxsysClientImpl(String axsysUrl, OkHttpClient client) {
        this.axsysUrl = axsysUrl;
        this.client = client;
    }

    @Override
    public List<NavIdent> hentAnsatte(EnhetId enhetId) {
        List<NavIdent> list;
        block8: {
            Request request = new Request.Builder().url(UrlUtils.joinPaths((String[])new String[]{this.axsysUrl, "api/v1/enhet/" + enhetId + "/brukere"})).header("Accept", RestUtils.MEDIA_TYPE_JSON.toString()).build();
            Response response = this.client.newCall(request).execute();
            try {
                RestUtils.throwIfNotSuccessful((Response)response);
                List brukere = RestUtils.parseJsonResponseArrayOrThrow((Response)response, AxsysEnhetBruker.class);
                list = brukere.stream().map(AxsysEnhetBruker::getAppIdent).collect(Collectors.toList());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            response.close();
        }
        return list;
    }

    @Override
    public List<AxsysEnhet> hentTilganger(NavIdent navIdent) {
        List<AxsysEnhet> list;
        block8: {
            Request request = new Request.Builder().url(UrlUtils.joinPaths((String[])new String[]{this.axsysUrl, "api/v1/tilgang/" + navIdent.get()})).header("Accept", RestUtils.MEDIA_TYPE_JSON.toString()).build();
            Response response = this.client.newCall(request).execute();
            try {
                RestUtils.throwIfNotSuccessful((Response)response);
                list = ((AxsysEnheter)RestUtils.parseJsonResponseOrThrow((Response)response, AxsysEnheter.class)).getEnheter();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            response.close();
        }
        return list;
    }

    public HealthCheckResult checkHealth() {
        return HealthCheckUtils.pingUrl((String)UrlUtils.joinPaths((String[])new String[]{this.axsysUrl, "/internal/isAlive"}), (OkHttpClient)this.client);
    }

    static class AxsysEnhetBruker {
        private NavIdent appIdent;
        private String historiskIdent;

        public NavIdent getAppIdent() {
            return this.appIdent;
        }

        public String getHistoriskIdent() {
            return this.historiskIdent;
        }

        public AxsysEnhetBruker setAppIdent(NavIdent appIdent) {
            this.appIdent = appIdent;
            return this;
        }

        public AxsysEnhetBruker setHistoriskIdent(String historiskIdent) {
            this.historiskIdent = historiskIdent;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AxsysEnhetBruker)) {
                return false;
            }
            AxsysEnhetBruker other = (AxsysEnhetBruker)o;
            if (!other.canEqual(this)) {
                return false;
            }
            NavIdent this$appIdent = this.getAppIdent();
            NavIdent other$appIdent = other.getAppIdent();
            if (this$appIdent == null ? other$appIdent != null : !this$appIdent.equals(other$appIdent)) {
                return false;
            }
            String this$historiskIdent = this.getHistoriskIdent();
            String other$historiskIdent = other.getHistoriskIdent();
            return !(this$historiskIdent == null ? other$historiskIdent != null : !this$historiskIdent.equals(other$historiskIdent));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AxsysEnhetBruker;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            NavIdent $appIdent = this.getAppIdent();
            result = result * 59 + ($appIdent == null ? 43 : $appIdent.hashCode());
            String $historiskIdent = this.getHistoriskIdent();
            result = result * 59 + ($historiskIdent == null ? 43 : $historiskIdent.hashCode());
            return result;
        }

        public String toString() {
            return "AxsysClientImpl.AxsysEnhetBruker(appIdent=" + this.getAppIdent() + ", historiskIdent=" + this.getHistoriskIdent() + ")";
        }
    }

    static class AxsysEnheter {
        List<AxsysEnhet> enheter;

        public List<AxsysEnhet> getEnheter() {
            return this.enheter;
        }

        public AxsysEnheter setEnheter(List<AxsysEnhet> enheter) {
            this.enheter = enheter;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AxsysEnheter)) {
                return false;
            }
            AxsysEnheter other = (AxsysEnheter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<AxsysEnhet> this$enheter = this.getEnheter();
            List<AxsysEnhet> other$enheter = other.getEnheter();
            return !(this$enheter == null ? other$enheter != null : !((Object)this$enheter).equals(other$enheter));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AxsysEnheter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<AxsysEnhet> $enheter = this.getEnheter();
            result = result * 59 + ($enheter == null ? 43 : ((Object)$enheter).hashCode());
            return result;
        }

        public String toString() {
            return "AxsysClientImpl.AxsysEnheter(enheter=" + this.getEnheter() + ")";
        }
    }
}

