/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.client.axsys;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.concurrent.TimeUnit;
import no.nav.common.client.axsys.AxsysClient;
import no.nav.common.client.axsys.AxsysEnhet;
import no.nav.common.client.utils.CacheUtils;
import no.nav.common.health.HealthCheckResult;
import no.nav.common.types.identer.EnhetId;
import no.nav.common.types.identer.NavIdent;

public class CachedAxsysClient
implements AxsysClient {
    private final AxsysClient axsysClient;
    private final Cache<EnhetId, List<NavIdent>> hentAnsatteCache;
    private final Cache<NavIdent, List<AxsysEnhet>> hentTilgangerCache;

    public CachedAxsysClient(AxsysClient axsysClient) {
        this.axsysClient = axsysClient;
        this.hentAnsatteCache = Caffeine.newBuilder().expireAfterWrite(12L, TimeUnit.HOURS).maximumSize(500L).build();
        this.hentTilgangerCache = Caffeine.newBuilder().expireAfterWrite(12L, TimeUnit.HOURS).maximumSize(10000L).build();
    }

    public CachedAxsysClient(AxsysClient axsysClient, Cache<NavIdent, List<AxsysEnhet>> hentTilgangerCache, Cache<EnhetId, List<NavIdent>> hentAnsatteCache) {
        this.axsysClient = axsysClient;
        this.hentTilgangerCache = hentTilgangerCache;
        this.hentAnsatteCache = hentAnsatteCache;
    }

    @Override
    public List<NavIdent> hentAnsatte(EnhetId enhetId) {
        return CacheUtils.tryCacheFirst(this.hentAnsatteCache, enhetId, () -> this.axsysClient.hentAnsatte(enhetId));
    }

    @Override
    public List<AxsysEnhet> hentTilganger(NavIdent navIdent) {
        return CacheUtils.tryCacheFirst(this.hentTilgangerCache, navIdent, () -> this.axsysClient.hentTilganger(navIdent));
    }

    public HealthCheckResult checkHealth() {
        return this.axsysClient.checkHealth();
    }
}

