/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.client.msgraph;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.nimbusds.jwt.JWTParser;
import java.util.concurrent.TimeUnit;
import no.nav.common.client.msgraph.MsGraphClient;
import no.nav.common.client.msgraph.UserData;
import no.nav.common.client.utils.CacheUtils;
import no.nav.common.health.HealthCheckResult;

public class CachedMsGraphClient
implements MsGraphClient {
    private final MsGraphClient msGraphClient;
    private final Cache<String, UserData> hentUserDataCache = Caffeine.newBuilder().expireAfterWrite(12L, TimeUnit.HOURS).maximumSize(10000L).build();
    private final Cache<String, String> hentOnPremisesSamAccountNameCache = Caffeine.newBuilder().expireAfterWrite(12L, TimeUnit.HOURS).maximumSize(20000L).build();

    public CachedMsGraphClient(MsGraphClient msGraphClient) {
        this.msGraphClient = msGraphClient;
    }

    @Override
    public UserData hentUserData(String userAccessToken) {
        String cacheKey = JWTParser.parse((String)userAccessToken).getJWTClaimsSet().getSubject();
        return CacheUtils.tryCacheFirst(this.hentUserDataCache, cacheKey, () -> this.msGraphClient.hentUserData(userAccessToken));
    }

    @Override
    public String hentOnPremisesSamAccountName(String userAccessToken) {
        String cacheKey = JWTParser.parse((String)userAccessToken).getJWTClaimsSet().getSubject();
        return CacheUtils.tryCacheFirst(this.hentOnPremisesSamAccountNameCache, cacheKey, () -> this.msGraphClient.hentOnPremisesSamAccountName(userAccessToken));
    }

    public HealthCheckResult checkHealth() {
        return this.msGraphClient.checkHealth();
    }
}

