/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.client.msgraph;

import java.util.Collections;
import java.util.List;
import no.nav.common.client.msgraph.MsGraphClient;
import no.nav.common.client.msgraph.OnPremisesSamAccountName;
import no.nav.common.client.msgraph.UserData;
import no.nav.common.health.HealthCheckResult;
import no.nav.common.health.HealthCheckUtils;
import no.nav.common.rest.client.RestClient;
import no.nav.common.rest.client.RestUtils;
import no.nav.common.utils.UrlUtils;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsGraphHttpClient
implements MsGraphClient {
    private static final Logger log = LoggerFactory.getLogger(MsGraphHttpClient.class);
    private static final List<String> USER_DATA_FIELDS = List.of("givenName", "surname", "displayName", "mail", "onPremisesSamAccountName", "id");
    private static final List<String> USER_DATA_NAV_IDENT_FIELDS = Collections.singletonList("onPremisesSamAccountName");
    private final String msGraphApiUrl;
    private final OkHttpClient client;

    public MsGraphHttpClient(String msGraphApiUrl) {
        this.msGraphApiUrl = msGraphApiUrl;
        this.client = RestClient.baseClient();
    }

    public MsGraphHttpClient(String msGraphApiUrl, OkHttpClient client) {
        this.msGraphApiUrl = msGraphApiUrl;
        this.client = client;
    }

    @Override
    public UserData hentUserData(String userAccessToken) {
        UserData userData;
        block8: {
            Request request = this.createMeRequest(userAccessToken, USER_DATA_FIELDS);
            Response response = this.client.newCall(request).execute();
            try {
                RestUtils.throwIfNotSuccessful((Response)response);
                userData = (UserData)RestUtils.parseJsonResponseOrThrow((Response)response, UserData.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            response.close();
        }
        return userData;
    }

    @Override
    public String hentOnPremisesSamAccountName(String userAccessToken) {
        String string;
        block8: {
            Request request = this.createMeRequest(userAccessToken, USER_DATA_NAV_IDENT_FIELDS);
            Response response = this.client.newCall(request).execute();
            try {
                RestUtils.throwIfNotSuccessful((Response)response);
                string = ((OnPremisesSamAccountName)RestUtils.parseJsonResponseOrThrow((Response)response, OnPremisesSamAccountName.class)).onPremisesSamAccountName;
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            response.close();
        }
        return string;
    }

    private Request createMeRequest(String userAccessToken, List<String> fields) {
        return new Request.Builder().url(UrlUtils.joinPaths((String[])new String[]{this.msGraphApiUrl, "/me"}) + String.format("?$select=%s", String.join((CharSequence)",", fields))).header("Authorization", "Bearer " + userAccessToken).build();
    }

    public HealthCheckResult checkHealth() {
        return HealthCheckUtils.pingUrl((String)this.msGraphApiUrl, (OkHttpClient)this.client);
    }
}

