/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.client.nom;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import no.nav.common.client.nom.NomClient;
import no.nav.common.client.nom.VeilederNavn;
import no.nav.common.client.utils.CacheUtils;
import no.nav.common.health.HealthCheckResult;
import no.nav.common.types.identer.NavIdent;

public class CachedNomClient
implements NomClient {
    private final NomClient nomClient;
    private final Cache<NavIdent, VeilederNavn> veilederNavnCache;

    public CachedNomClient(NomClient nomClient, Cache<NavIdent, VeilederNavn> veilederNavnCache) {
        this.nomClient = nomClient;
        this.veilederNavnCache = veilederNavnCache;
    }

    public CachedNomClient(NomClient nomClient) {
        this.nomClient = nomClient;
        this.veilederNavnCache = Caffeine.newBuilder().expireAfterWrite(12L, TimeUnit.HOURS).maximumSize(10000L).build();
    }

    @Override
    public VeilederNavn finnNavn(NavIdent navIdent) {
        return CacheUtils.tryCacheFirst(this.veilederNavnCache, navIdent, () -> this.nomClient.finnNavn(navIdent));
    }

    @Override
    public List<VeilederNavn> finnNavn(List<NavIdent> navIdenter) {
        ArrayList<VeilederNavn> veilederNavnListe = new ArrayList<VeilederNavn>();
        ArrayList<NavIdent> uncachedNavIdenter = new ArrayList<NavIdent>();
        navIdenter.forEach(navIdent -> {
            VeilederNavn veilederNavn = (VeilederNavn)this.veilederNavnCache.getIfPresent(navIdent);
            if (veilederNavn != null) {
                veilederNavnListe.add(veilederNavn);
            } else {
                uncachedNavIdenter.add((NavIdent)navIdent);
            }
        });
        if (!uncachedNavIdenter.isEmpty()) {
            List<VeilederNavn> funnetNavn = this.nomClient.finnNavn(uncachedNavIdenter);
            funnetNavn.forEach(navn -> this.veilederNavnCache.put((Object)navn.navIdent, navn));
            veilederNavnListe.addAll(funnetNavn);
        }
        return veilederNavnListe;
    }

    public HealthCheckResult checkHealth() {
        return this.nomClient.checkHealth();
    }
}

