/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.client.nom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.nav.common.client.nom.NomClient;
import no.nav.common.client.nom.VeilederNavn;
import no.nav.common.client.utils.graphql.GraphqlRequest;
import no.nav.common.client.utils.graphql.GraphqlRequestBuilder;
import no.nav.common.client.utils.graphql.GraphqlResponse;
import no.nav.common.client.utils.graphql.GraphqlUtils;
import no.nav.common.health.HealthCheckResult;
import no.nav.common.health.HealthCheckUtils;
import no.nav.common.json.JsonUtils;
import no.nav.common.log.LogUtils;
import no.nav.common.rest.client.RestClient;
import no.nav.common.rest.client.RestUtils;
import no.nav.common.types.identer.NavIdent;
import no.nav.common.utils.CollectionUtils;
import no.nav.common.utils.UrlUtils;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class NomClientImpl
implements NomClient {
    private static final Logger log = LoggerFactory.getLogger(NomClientImpl.class);
    private static final int NOM_MAX_BATCH_SIZE = 100;
    private final GraphqlRequestBuilder<RessursQuery.Variables> ressurserQueryRequestBuilder = new GraphqlRequestBuilder("nom/ressurser.graphql");
    private final String nomApiUrl;
    private final OkHttpClient client;
    private final Supplier<String> serviceTokenSupplier;

    public NomClientImpl(String nomApiUrl, Supplier<String> serviceTokenSupplier) {
        this.nomApiUrl = nomApiUrl;
        this.serviceTokenSupplier = serviceTokenSupplier;
        this.client = RestClient.baseClient();
    }

    public NomClientImpl(String nomApiUrl, Supplier<String> serviceTokenSupplier, OkHttpClient client) {
        this.nomApiUrl = nomApiUrl;
        this.serviceTokenSupplier = serviceTokenSupplier;
        this.client = client;
    }

    @Override
    public VeilederNavn finnNavn(NavIdent navIdent) {
        List<VeilederNavn> veilederNavn = this.finnNavn(Collections.singletonList(navIdent));
        if (veilederNavn.isEmpty()) {
            throw new IllegalStateException("Fant ikke navn for NAV-ident: " + navIdent);
        }
        return veilederNavn.get(0);
    }

    @Override
    public List<VeilederNavn> finnNavn(List<NavIdent> navIdenter) {
        Map contextMap = MDC.getCopyOfContextMap();
        return CollectionUtils.partition(navIdenter, (int)100).parallelStream().flatMap(identBatch -> (Stream)LogUtils.runWithMDCContext((Map)contextMap, () -> this.hentNavnTilIdenter((List<NavIdent>)identBatch).stream())).collect(Collectors.toList());
    }

    private List<VeilederNavn> hentNavnTilIdenter(List<NavIdent> navIdenter) {
        List<VeilederNavn> list;
        block8: {
            GraphqlRequest<RessursQuery.Variables> gqlRequest = this.ressurserQueryRequestBuilder.buildRequest(new RessursQuery.Variables(navIdenter));
            Request request = new Request.Builder().url(UrlUtils.joinPaths((String[])new String[]{this.nomApiUrl, "/graphql"})).header("Accept", RestUtils.MEDIA_TYPE_JSON.toString()).header("Authorization", RestUtils.createBearerToken((String)this.serviceTokenSupplier.get())).post(RequestBody.create((MediaType)RestUtils.MEDIA_TYPE_JSON, (String)JsonUtils.toJson(gqlRequest))).build();
            Response response = this.client.newCall(request).execute();
            try {
                RestUtils.throwIfNotSuccessful((Response)response);
                String gqlJsonResponse = (String)RestUtils.getBodyStr((Response)response).orElseThrow(() -> new IllegalStateException("Body is missing from NOM response"));
                RessursQuery.Response graphqlResponse = (RessursQuery.Response)JsonUtils.fromJson((String)gqlJsonResponse, RessursQuery.Response.class);
                GraphqlUtils.logWarningIfError(graphqlResponse);
                GraphqlUtils.throwIfMissingData(graphqlResponse);
                list = this.mapTilVeilederNavn(graphqlResponse);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            response.close();
        }
        return list;
    }

    private List<VeilederNavn> mapTilVeilederNavn(RessursQuery.Response graphqlResponse) {
        List<RessursQuery.ResponseData.RessurserItem> ressurser = ((RessursQuery.ResponseData)graphqlResponse.getData()).ressurser;
        ArrayList<VeilederNavn> veilederNavnListe = new ArrayList<VeilederNavn>(ressurser.size());
        ressurser.forEach(ressursItem -> {
            RessursQuery.ResponseData.RessurserItem.Ressurs ressurs = ressursItem.ressurs;
            if (ressurs == null || ressurs.person == null) {
                log.error("Fant ikke navn til veileder med ident: {}", (Object)ressursItem.id);
                return;
            }
            VeilederNavn veilederNavn = new VeilederNavn().setNavIdent(ressurs.navIdent).setFornavn(ressurs.person.navn.fornavn).setMellomnavn(ressurs.person.navn.mellomnavn).setEtternavn(ressurs.person.navn.etternavn);
            veilederNavnListe.add(veilederNavn);
        });
        return veilederNavnListe;
    }

    public HealthCheckResult checkHealth() {
        return HealthCheckUtils.pingUrl((String)UrlUtils.joinPaths((String[])new String[]{this.nomApiUrl, "/internal/health/liveness"}), (OkHttpClient)this.client);
    }

    static class RessursQuery {
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RessursQuery)) {
                return false;
            }
            RessursQuery other = (RessursQuery)o;
            return other.canEqual(this);
        }

        protected boolean canEqual(Object other) {
            return other instanceof RessursQuery;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public String toString() {
            return "NomClientImpl.RessursQuery()";
        }

        static class ResponseData {
            List<RessurserItem> ressurser;

            public List<RessurserItem> getRessurser() {
                return this.ressurser;
            }

            public void setRessurser(List<RessurserItem> ressurser) {
                this.ressurser = ressurser;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ResponseData)) {
                    return false;
                }
                ResponseData other = (ResponseData)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<RessurserItem> this$ressurser = this.getRessurser();
                List<RessurserItem> other$ressurser = other.getRessurser();
                return !(this$ressurser == null ? other$ressurser != null : !((Object)this$ressurser).equals(other$ressurser));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ResponseData;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<RessurserItem> $ressurser = this.getRessurser();
                result = result * 59 + ($ressurser == null ? 43 : ((Object)$ressurser).hashCode());
                return result;
            }

            public String toString() {
                return "NomClientImpl.RessursQuery.ResponseData(ressurser=" + this.getRessurser() + ")";
            }

            static class RessurserItem {
                String id;
                Ressurs ressurs;

                RessurserItem() {
                }

                static class Ressurs {
                    NavIdent navIdent;
                    Person person;

                    Ressurs() {
                    }

                    static class Person {
                        Navn navn;

                        public Navn getNavn() {
                            return this.navn;
                        }

                        public void setNavn(Navn navn) {
                            this.navn = navn;
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof Person)) {
                                return false;
                            }
                            Person other = (Person)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            Navn this$navn = this.getNavn();
                            Navn other$navn = other.getNavn();
                            return !(this$navn == null ? other$navn != null : !((Object)this$navn).equals(other$navn));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof Person;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            Navn $navn = this.getNavn();
                            result = result * 59 + ($navn == null ? 43 : ((Object)$navn).hashCode());
                            return result;
                        }

                        public String toString() {
                            return "NomClientImpl.RessursQuery.ResponseData.RessurserItem.Ressurs.Person(navn=" + this.getNavn() + ")";
                        }

                        static class Navn {
                            String fornavn;
                            String mellomnavn;
                            String etternavn;

                            public String getFornavn() {
                                return this.fornavn;
                            }

                            public String getMellomnavn() {
                                return this.mellomnavn;
                            }

                            public String getEtternavn() {
                                return this.etternavn;
                            }

                            public void setFornavn(String fornavn) {
                                this.fornavn = fornavn;
                            }

                            public void setMellomnavn(String mellomnavn) {
                                this.mellomnavn = mellomnavn;
                            }

                            public void setEtternavn(String etternavn) {
                                this.etternavn = etternavn;
                            }

                            public boolean equals(Object o) {
                                if (o == this) {
                                    return true;
                                }
                                if (!(o instanceof Navn)) {
                                    return false;
                                }
                                Navn other = (Navn)o;
                                if (!other.canEqual(this)) {
                                    return false;
                                }
                                String this$fornavn = this.getFornavn();
                                String other$fornavn = other.getFornavn();
                                if (this$fornavn == null ? other$fornavn != null : !this$fornavn.equals(other$fornavn)) {
                                    return false;
                                }
                                String this$mellomnavn = this.getMellomnavn();
                                String other$mellomnavn = other.getMellomnavn();
                                if (this$mellomnavn == null ? other$mellomnavn != null : !this$mellomnavn.equals(other$mellomnavn)) {
                                    return false;
                                }
                                String this$etternavn = this.getEtternavn();
                                String other$etternavn = other.getEtternavn();
                                return !(this$etternavn == null ? other$etternavn != null : !this$etternavn.equals(other$etternavn));
                            }

                            protected boolean canEqual(Object other) {
                                return other instanceof Navn;
                            }

                            public int hashCode() {
                                int PRIME = 59;
                                int result = 1;
                                String $fornavn = this.getFornavn();
                                result = result * 59 + ($fornavn == null ? 43 : $fornavn.hashCode());
                                String $mellomnavn = this.getMellomnavn();
                                result = result * 59 + ($mellomnavn == null ? 43 : $mellomnavn.hashCode());
                                String $etternavn = this.getEtternavn();
                                result = result * 59 + ($etternavn == null ? 43 : $etternavn.hashCode());
                                return result;
                            }

                            public String toString() {
                                return "NomClientImpl.RessursQuery.ResponseData.RessurserItem.Ressurs.Person.Navn(fornavn=" + this.getFornavn() + ", mellomnavn=" + this.getMellomnavn() + ", etternavn=" + this.getEtternavn() + ")";
                            }
                        }
                    }
                }
            }
        }

        static class Response
        extends GraphqlResponse<ResponseData> {
            Response() {
            }
        }

        static final class Variables {
            private final List<NavIdent> identer;

            public Variables(List<NavIdent> identer) {
                this.identer = identer;
            }

            public List<NavIdent> getIdenter() {
                return this.identer;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Variables)) {
                    return false;
                }
                Variables other = (Variables)o;
                List<NavIdent> this$identer = this.getIdenter();
                List<NavIdent> other$identer = other.getIdenter();
                return !(this$identer == null ? other$identer != null : !((Object)this$identer).equals(other$identer));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<NavIdent> $identer = this.getIdenter();
                result = result * 59 + ($identer == null ? 43 : ((Object)$identer).hashCode());
                return result;
            }

            public String toString() {
                return "NomClientImpl.RessursQuery.Variables(identer=" + this.getIdenter() + ")";
            }
        }
    }
}

