/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.client.norg2;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.concurrent.TimeUnit;
import no.nav.common.client.norg2.Enhet;
import no.nav.common.client.norg2.Norg2Client;
import no.nav.common.client.utils.CacheUtils;
import no.nav.common.health.HealthCheckResult;

public class CachedNorg2Client
implements Norg2Client {
    private final Norg2Client norg2Client;
    private final Cache<String, List<Enhet>> alleAktiveEnheterCache = Caffeine.newBuilder().expireAfterWrite(12L, TimeUnit.HOURS).maximumSize(1L).build();
    private final Cache<String, Enhet> hentEnhetCache = Caffeine.newBuilder().expireAfterWrite(12L, TimeUnit.HOURS).maximumSize(1000L).build();
    private final Cache<String, Enhet> hentEnhetFraOmradeCache = Caffeine.newBuilder().expireAfterWrite(12L, TimeUnit.HOURS).maximumSize(1000L).build();

    public CachedNorg2Client(Norg2Client norg2Client) {
        this.norg2Client = norg2Client;
    }

    @Override
    public List<Enhet> alleAktiveEnheter() {
        return CacheUtils.tryCacheFirst(this.alleAktiveEnheterCache, "ALLE_ENHETER", this.norg2Client::alleAktiveEnheter);
    }

    @Override
    public Enhet hentEnhet(String enhetId) {
        return CacheUtils.tryCacheFirst(this.hentEnhetCache, enhetId, () -> this.norg2Client.hentEnhet(enhetId));
    }

    @Override
    public Enhet hentTilhorendeEnhet(String geografiskOmrade) {
        return CacheUtils.tryCacheFirst(this.hentEnhetFraOmradeCache, geografiskOmrade, () -> this.norg2Client.hentTilhorendeEnhet(geografiskOmrade));
    }

    public HealthCheckResult checkHealth() {
        return this.norg2Client.checkHealth();
    }
}

