/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.client.norg2;

import java.util.List;
import no.nav.common.client.norg2.Enhet;
import no.nav.common.client.norg2.Norg2Client;
import no.nav.common.health.HealthCheckResult;
import no.nav.common.health.HealthCheckUtils;
import no.nav.common.rest.client.RestClient;
import no.nav.common.rest.client.RestUtils;
import no.nav.common.utils.UrlUtils;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NorgHttp2Client
implements Norg2Client {
    private static final Logger log = LoggerFactory.getLogger(NorgHttp2Client.class);
    private final String norg2Url;
    private final OkHttpClient client;

    public NorgHttp2Client(String norg2Url) {
        this.norg2Url = norg2Url;
        this.client = RestClient.baseClient();
    }

    public NorgHttp2Client(String norg2Url, OkHttpClient client) {
        this.norg2Url = norg2Url;
        this.client = client;
    }

    @Override
    public List<Enhet> alleAktiveEnheter() {
        List list;
        block8: {
            Request request = new Request.Builder().url(UrlUtils.joinPaths((String[])new String[]{this.norg2Url, "/api/v1/enhet?enhetStatusListe=AKTIV"})).build();
            Response response = this.client.newCall(request).execute();
            try {
                RestUtils.throwIfNotSuccessful((Response)response);
                list = RestUtils.parseJsonResponseArrayOrThrow((Response)response, Enhet.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            response.close();
        }
        return list;
    }

    @Override
    public Enhet hentEnhet(String enhetId) {
        Enhet enhet;
        block8: {
            Request request = new Request.Builder().url(UrlUtils.joinPaths((String[])new String[]{this.norg2Url, "/api/v1/enhet/", enhetId})).build();
            Response response = this.client.newCall(request).execute();
            try {
                RestUtils.throwIfNotSuccessful((Response)response);
                enhet = (Enhet)RestUtils.parseJsonResponseOrThrow((Response)response, Enhet.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            response.close();
        }
        return enhet;
    }

    @Override
    public Enhet hentTilhorendeEnhet(String geografiskOmrade) {
        Enhet enhet;
        block8: {
            Request request = new Request.Builder().url(UrlUtils.joinPaths((String[])new String[]{this.norg2Url, "/api/v1/enhet/navkontor/", geografiskOmrade})).build();
            Response response = this.client.newCall(request).execute();
            try {
                RestUtils.throwIfNotSuccessful((Response)response);
                enhet = (Enhet)RestUtils.parseJsonResponseOrThrow((Response)response, Enhet.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            response.close();
        }
        return enhet;
    }

    public HealthCheckResult checkHealth() {
        return HealthCheckUtils.pingUrl((String)UrlUtils.joinPaths((String[])new String[]{this.norg2Url, "/internal/isAlive"}), (OkHttpClient)this.client);
    }
}

