/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.client.pdl;

import java.util.function.Supplier;
import no.nav.common.client.pdl.PdlClient;
import no.nav.common.client.pdl.Tema;
import no.nav.common.client.utils.graphql.GraphqlRequest;
import no.nav.common.client.utils.graphql.GraphqlResponse;
import no.nav.common.health.HealthCheckResult;
import no.nav.common.health.HealthCheckUtils;
import no.nav.common.json.JsonUtils;
import no.nav.common.rest.client.RestClient;
import no.nav.common.rest.client.RestUtils;
import no.nav.common.utils.UrlUtils;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class PdlClientImpl
implements PdlClient {
    private static final Tema DEFAULT_TEMA = Tema.GEN;
    private final String pdlUrl;
    private final Tema pdlTema;
    private final OkHttpClient client;
    private final Supplier<String> userTokenSupplier;
    private final Supplier<String> consumerTokenSupplier;

    public PdlClientImpl(String pdlUrl, Tema tema, Supplier<String> userTokenSupplier, Supplier<String> consumerTokenSupplier) {
        this.pdlUrl = pdlUrl;
        this.pdlTema = tema;
        this.userTokenSupplier = userTokenSupplier;
        this.consumerTokenSupplier = consumerTokenSupplier;
        this.client = RestClient.baseClient();
    }

    public PdlClientImpl(String pdlUrl, Supplier<String> userTokenSupplier, Supplier<String> consumerTokenSupplier) {
        this(pdlUrl, DEFAULT_TEMA, userTokenSupplier, consumerTokenSupplier);
    }

    @Override
    public String rawRequest(String gqlRequestJson) {
        String string;
        block8: {
            Request request = new Request.Builder().url(UrlUtils.joinPaths((String[])new String[]{this.pdlUrl, "/graphql"})).header("Accept", RestUtils.MEDIA_TYPE_JSON.toString()).header("Authorization", RestUtils.createBearerToken((String)this.userTokenSupplier.get())).header("Nav-Consumer-Token", RestUtils.createBearerToken((String)this.consumerTokenSupplier.get())).header("Tema", this.pdlTema.name()).post(RequestBody.create((MediaType)RestUtils.MEDIA_TYPE_JSON, (String)gqlRequestJson)).build();
            Response response = this.client.newCall(request).execute();
            try {
                RestUtils.throwIfNotSuccessful((Response)response);
                string = (String)RestUtils.getBodyStr((Response)response).orElseThrow(() -> new IllegalStateException("Body is missing from PDL response"));
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            response.close();
        }
        return string;
    }

    @Override
    public <D extends GraphqlResponse> D request(GraphqlRequest<?> graphqlRequest, Class<D> graphqlResponseClass) {
        String graphqlJsonResponse = this.rawRequest(JsonUtils.toJson(graphqlRequest));
        return (D)((GraphqlResponse)JsonUtils.fromJson((String)graphqlJsonResponse, graphqlResponseClass));
    }

    public HealthCheckResult checkHealth() {
        return HealthCheckUtils.pingUrl((String)UrlUtils.joinPaths((String[])new String[]{this.pdlUrl, "/internal/health/liveness"}), (OkHttpClient)this.client);
    }
}

