/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.client.utils.graphql;

import no.nav.common.client.utils.graphql.GraphqlErrorException;
import no.nav.common.client.utils.graphql.GraphqlNoDataException;
import no.nav.common.client.utils.graphql.GraphqlResponse;
import no.nav.common.json.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphqlUtils {
    private static final Logger log = LoggerFactory.getLogger(GraphqlUtils.class);

    public static void throwIfErrorOrMissingData(GraphqlResponse<?> response) {
        GraphqlUtils.throwIfError(response);
        GraphqlUtils.throwIfMissingData(response);
    }

    public static void logWarningIfError(GraphqlResponse<?> response) {
        if (response.getErrors() != null) {
            log.warn("Graphql response feilet med feilmelding: " + JsonUtils.toJson(response.getErrors()));
        }
    }

    public static void throwIfError(GraphqlResponse<?> response) {
        if (response.getErrors() != null) {
            log.error("Graphql response feilet med feilmelding: " + JsonUtils.toJson(response.getErrors()));
            throw new GraphqlErrorException(response.errors);
        }
    }

    public static void throwIfMissingData(GraphqlResponse<?> response) {
        if (response.getData() == null) {
            log.error("Graphql response mangler data");
            throw new GraphqlNoDataException();
        }
    }
}

