/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.health;

import no.nav.common.health.HealthCheckResult;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class HealthCheckUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HealthCheckResult pingUrl(String url, OkHttpClient client) {
        Request request = new Request.Builder().url(url).build();
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                HealthCheckResult healthCheckResult2 = HealthCheckResult.unhealthy(String.format("Helsesjekk feilet mot %s. Fikk uventet status %d", url, response.code()));
                return healthCheckResult2;
            }
            HealthCheckResult healthCheckResult = HealthCheckResult.healthy();
            return healthCheckResult;
        }
        catch (Exception e) {
            return HealthCheckResult.unhealthy("Helsesjekk feilet mot " + url, e);
        }
    }
}

