/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.health;

import java.util.List;
import java.util.Optional;
import no.nav.common.health.HealthCheck;
import no.nav.common.health.HealthCheckResult;

public class HealthChecker {
    public static void throwOnFirstFailing(List<HealthCheck> healthChecks) {
        HealthChecker.findFirstFailingCheck(healthChecks).ifPresent(failedCheckResult -> {
            throw new RuntimeException("Health check failed: " + failedCheckResult.getErrorMessage());
        });
    }

    public static Optional<HealthCheckResult> findFirstFailingCheck(List<HealthCheck> healthChecks) {
        for (HealthCheck healthCheck : healthChecks) {
            HealthCheckResult result = healthCheck.checkHealth();
            if (result.isHealthy()) continue;
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

