/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.health.selftest;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import no.nav.common.health.HealthCheckResult;
import no.nav.common.health.selftest.SelfTestStatus;
import no.nav.common.health.selftest.SelfTestUtils;
import no.nav.common.health.selftest.SelftTestCheckResult;
import no.nav.common.utils.EnvironmentUtils;

public class SelftestHtmlGenerator {
    private static final String htmlTemplate = SelftestHtmlGenerator.readResourceFile("/selftest/SelfTestPage.html");

    public static String generate(List<SelftTestCheckResult> checkResults) {
        return SelftestHtmlGenerator.generate(checkResults, EnvironmentUtils.resolveHostName(), LocalDateTime.now());
    }

    public static String generate(List<SelftTestCheckResult> checkResults, String host, LocalDateTime timestamp) {
        List tabellrader = checkResults.stream().map(SelftestHtmlGenerator::lagTabellrad).collect(Collectors.toList());
        String html = htmlTemplate;
        html = html.replace("${aggregertStatus}", SelftestHtmlGenerator.getStatusNavnElement(SelfTestUtils.aggregateStatus(checkResults), "span"));
        html = html.replace("${resultater}", String.join((CharSequence)"\n", tabellrader));
        html = html.replace("${host}", "Host: " + host);
        html = html.replace("${generert-tidspunkt}", timestamp.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        return html;
    }

    private static String getStatusNavnElement(SelfTestStatus selfTestStatus, String nodeType) {
        switch (selfTestStatus == null ? SelfTestStatus.ERROR : selfTestStatus) {
            case ERROR: {
                return SelftestHtmlGenerator.getHtmlNode(nodeType, "roundSmallBox error", "ERROR");
            }
            case WARNING: {
                return SelftestHtmlGenerator.getHtmlNode(nodeType, "roundSmallBox warning", "WARNING");
            }
        }
        return SelftestHtmlGenerator.getHtmlNode(nodeType, "roundSmallBox ok", "OK");
    }

    private static String getHtmlNode(String nodeType, String classes, String content) {
        return MessageFormat.format("<{0} class=\"{1}\">{2}</{0}>", nodeType, classes, content);
    }

    private static String lagTabellrad(SelftTestCheckResult result) {
        String status = SelftestHtmlGenerator.getStatusNavnElement(SelfTestUtils.toStatus(result), "div");
        String kritisk = result.selfTestCheck.isCritical() ? "Ja" : "Nei";
        return SelftestHtmlGenerator.tableRow(status, kritisk, result.timeUsed + " ms", result.selfTestCheck.getDescription(), SelftestHtmlGenerator.getFeilmelding(result.checkResult));
    }

    private static String getFeilmelding(HealthCheckResult checkResult) {
        if (checkResult.isHealthy()) {
            return "";
        }
        Object feilmelding = "";
        Optional<String> maybeErrorMessage = checkResult.getErrorMessage();
        Optional<Throwable> maybeError = checkResult.getError();
        if (maybeErrorMessage.isPresent()) {
            feilmelding = (String)feilmelding + SelftestHtmlGenerator.getHtmlNode("p", "feilmelding", maybeErrorMessage.get());
        }
        if (maybeError.isPresent()) {
            feilmelding = (String)feilmelding + SelftestHtmlGenerator.getHtmlNode("p", "stacktrace", maybeError.get().toString());
        }
        return feilmelding;
    }

    private static String tableRow(Object ... tdContents) {
        String row = Arrays.stream(tdContents).map(o -> Optional.ofNullable(o).map(Object::toString).orElse("")).collect(Collectors.joining("</td><td>"));
        return "<tr><td>" + row + "</td></tr>\n";
    }

    private static String readResourceFile(String fileName) {
        String string;
        block8: {
            InputStream resourceStream = SelftestHtmlGenerator.class.getResourceAsStream(fileName);
            try {
                string = new String(resourceStream.readAllBytes(), StandardCharsets.UTF_8);
                if (resourceStream == null) break block8;
            }
            catch (Throwable throwable) {
                if (resourceStream != null) {
                    try {
                        resourceStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            resourceStream.close();
        }
        return string;
    }
}

