/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.health;

import java.util.List;
import java.util.Optional;
import no.nav.common.health.HealthCheck;
import no.nav.common.health.HealthCheckResult;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class HealthCheckUtils {
    public static HealthCheckResult pingUrl(String url, OkHttpClient client) {
        Request request = new Request.Builder().url(url).build();
        return HealthCheckUtils.pingUrl(request, client);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HealthCheckResult pingUrl(Request request, OkHttpClient client) {
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                HealthCheckResult healthCheckResult2 = HealthCheckResult.unhealthy(String.format("Helsesjekk feilet mot %s. Fikk uventet status %d", request.url(), response.code()));
                return healthCheckResult2;
            }
            HealthCheckResult healthCheckResult = HealthCheckResult.healthy();
            return healthCheckResult;
        }
        catch (Exception e) {
            return HealthCheckResult.unhealthy("Helsesjekk feilet mot " + request.url(), e);
        }
    }

    public static HealthCheckResult safeCheckHealth(HealthCheck healthCheck) {
        try {
            return healthCheck.checkHealth();
        }
        catch (Exception e) {
            return HealthCheckResult.unhealthy("Failed to check health", e);
        }
    }

    public static void throwOnFirstFailing(List<HealthCheck> healthChecks) {
        HealthCheckUtils.findFirstFailingCheck(healthChecks).ifPresent(failedCheckResult -> {
            throw new RuntimeException("Health check failed: " + failedCheckResult.getErrorMessage());
        });
    }

    public static Optional<HealthCheckResult> findFirstFailingCheck(List<HealthCheck> healthChecks) {
        for (HealthCheck healthCheck : healthChecks) {
            HealthCheckResult result = HealthCheckUtils.safeCheckHealth(healthCheck);
            if (result.isHealthy()) continue;
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

