/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.health.selftest;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNull;
import java.util.List;
import no.nav.common.health.selftest.SelfTestChecks;
import no.nav.common.health.selftest.SelfTestStatus;
import no.nav.common.health.selftest.SelfTestUtils;
import no.nav.common.health.selftest.SelftTestCheckResult;

public class SelfTestMeterBinder
implements MeterBinder {
    private final SelfTestChecks selfTestChecks;
    private final boolean runChecksInParallel;

    public SelfTestMeterBinder(SelfTestChecks selfTestChecks) {
        this.selfTestChecks = selfTestChecks;
        this.runChecksInParallel = false;
    }

    public SelfTestMeterBinder(SelfTestChecks selfTestChecks, boolean runChecksInParallel) {
        this.selfTestChecks = selfTestChecks;
        this.runChecksInParallel = runChecksInParallel;
    }

    public void bindTo(@NonNull MeterRegistry registry) {
        Gauge.builder((String)"selftests_aggregate_result_status", this::getAggregateResult).description("aggregert status for alle selftester. 0=ok, 1=kritisk feil, 2=ikke-kritisk feil").register(registry);
    }

    private int getAggregateResult() {
        List<SelftTestCheckResult> selftTestCheckResults = this.runChecksInParallel ? SelfTestUtils.checkAllParallel(this.selfTestChecks.getSelfTestChecks()) : SelfTestUtils.checkAll(this.selfTestChecks.getSelfTestChecks());
        SelfTestStatus selfTestStatus = SelfTestUtils.aggregateStatus(selftTestCheckResults);
        return selfTestStatus.statusKode;
    }
}

